/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.net;

import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import jp.ac.nii.hcp.client.net.RepositoryConnection;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.ClientConfiguration;
import jp.ac.nii.hcp.client.shared.ClientStatus;
import jp.ac.nii.hcp.client.shared.CommitConflictException;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPMixedWrapper;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectHistory;
import jp.ac.nii.hcp.shared.model.HCPProjectList;
import jp.ac.nii.hcp.shared.model.HCPProjectMember;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.model.ProjectCommitWrapper;
import jp.ac.nii.hcp.shared.model.ProjectDifference;

public class ProjectClient {
    private RepositoryConnection connection;
    private ClientConfiguration config;

    public ProjectClient(RepositoryConnection connection, ClientConfiguration config) {
        this.connection = connection;
        this.config = config;
    }

    public HCPProjectList list(Integer page, Integer limit) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").toUrl();
        WebResource resource = this.connection.resource(url);
        if (page != null) {
            resource = resource.queryParam("page", page.toString());
        }
        if (limit != null) {
            resource = resource.queryParam("limit", limit.toString());
        }
        HCPProjectList projects = this.connection.request(resource, "GET", MediaType.APPLICATION_XML_TYPE, MediaType.TEXT_HTML_TYPE, HCPProjectList.class);
        return projects;
    }

    public HCPProject get(String name, int revision) throws IOException, UnauthorizedException {
        return this.get(name, revision, 0);
    }

    public HCPProject get(String name, int revision, int from) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(name, true).toUrl();
        WebResource resource = this.connection.resource(url);
        if (revision > 0) {
            resource = resource.queryParam("revision", String.valueOf(revision));
        }
        if (from > 0) {
            resource = resource.queryParam("from", String.valueOf(from));
        }
        try {
            return (HCPProject)this.connection.request(resource, "GET", MediaType.APPLICATION_XML_TYPE, null, HCPMixedWrapper.class).getHCPElement(HCPProject.class);
        }
        catch (UniformInterfaceException e) {
            int status = e.getResponse().getStatus();
            if (status == 404) {
                return null;
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    public HCPProject add(HCPProject project, String groupId, List<File> files) throws IOException, UnauthorizedException, HCPClientException {
        wrapper = new HCPMixedWrapper();
        wrapper.add((Object)project);
        group = new HCPUserGroup(0, groupId, null, null);
        wrapper.add((Object)group);
        mp = new FormDataMultiPart();
        mp.field("project", (Object)wrapper, MediaType.APPLICATION_XML_TYPE);
        index = 1;
        streams = new ArrayList<FileInputStream>();
        for (File attachmentFile : files) {
            entity = new FileInputStream(attachmentFile);
            mp.field("entity" + index++, (Object)entity, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            streams.add(entity);
        }
        url = this.config.repositoryAPIURL().append("project").toUrl();
        try {
            try {
                project = (HCPProject)this.connection.request(url, "POST", MediaType.APPLICATION_XML_TYPE, MediaType.MULTIPART_FORM_DATA_TYPE, HCPMixedWrapper.class, (Object)mp).getHCPElement(HCPProject.class);
            }
            catch (UniformInterfaceException e) {
                if (e.getResponse().getStatus() == 409) {
                    throw new HCPClientException(ClientStatus.PROJECT_ALREADY_EXISTS, String.format("Project '%s' already exists in repository.", new Object[]{project.name}), e);
                }
                throw new HCPClientException(ClientStatus.HTTP_ERROR, String.format("Project '%s' is not imported in repository because of HTTP error.", new Object[]{project.name}), e);
            }
        }
        finally {
            ** for (entity : streams)
        }
lbl-1000:
        // 1 sources

        {
            entity.close();
            continue;
        }
lbl32:
        // 1 sources

        return project;
    }

    public void delete(String name) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(name, true).toUrl();
        this.connection.request(url, "DELETE", null, null, null);
    }

    public List<HCPProjectHistory> getHistories(String name, int from, int to) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(name, true).append("history").toUrl();
        WebResource resource = this.connection.resource(url);
        if (from > 0) {
            resource = resource.queryParam("from", String.valueOf(from));
        }
        if (to > 0) {
            resource = resource.queryParam("to", String.valueOf(to));
        }
        HCPMixedWrapper wrapper = this.connection.request(resource, "GET", MediaType.APPLICATION_XML_TYPE, null, HCPMixedWrapper.class);
        return wrapper.getHCPElements(HCPProjectHistory.class);
    }

    public void setAccessibility(String name, HCPProject.Accessibility accessibility) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(name, true).append("accessibility").toUrl();
        HCPProject project = new HCPProject();
        project.accessibility = accessibility;
        HCPMixedWrapper wrapper = new HCPMixedWrapper().add((Object)project);
        this.connection.request(url, "PUT", null, MediaType.APPLICATION_XML_TYPE, null, (Object)wrapper);
    }

    public List<HCPProjectMember> getMembers(String name) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(name, true).append("member").toUrl();
        HCPMixedWrapper wrapper = this.connection.request(url, "GET", MediaType.APPLICATION_XML_TYPE, null, HCPMixedWrapper.class);
        return wrapper.getHCPElements(HCPProjectMember.class);
    }

    public boolean setMember(String name, String groupId, HCPProject.GroupPermission permission) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(name, true).append("member").append(groupId, true).toUrl();
        HCPProjectMember member = new HCPProjectMember(new HCPUserGroup(0, groupId, null, null), null, permission);
        HCPMixedWrapper wrapper = new HCPMixedWrapper().add((Object)member);
        try {
            this.connection.request(url, "POST", null, MediaType.APPLICATION_XML_TYPE, null, (Object)wrapper);
            return true;
        }
        catch (UniformInterfaceException e) {
            return false;
        }
    }

    public void deleteMember(String name, String groupId) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(name, true).append("member").append(groupId, true).toUrl();
        this.connection.request(url, "DELETE", null, null, null);
    }

    public ProjectDifference commit(String name, ProjectDifference diff, String comment, boolean force) throws IOException, UnauthorizedException, HCPClientException {
        String url = this.config.repositoryAPIURL().append("project").append(name, true).toUrl();
        ProjectCommitWrapper wrapper = new ProjectCommitWrapper(diff.revision, comment, force);
        wrapper.difference = diff;
        try {
            ProjectCommitWrapper committed = this.connection.request(url, "PUT", MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE, ProjectCommitWrapper.class, (Object)wrapper);
            return committed.difference;
        }
        catch (UniformInterfaceException e) {
            int status = e.getResponse().getStatus();
            switch (status) {
                case 404: {
                    throw new HCPClientException(ClientStatus.PROJECT_NOT_REGISTERED, String.format("Project '%s' does not exist in repository.", name), e);
                }
                case 409: {
                    ProjectCommitWrapper conflicted = (ProjectCommitWrapper)e.getResponse().getEntity(ProjectCommitWrapper.class);
                    throw new CommitConflictException(String.format("Committing project '%s' failed because of conflict.", name), conflicted.difference, (Throwable)e);
                }
            }
            throw new HCPClientException(ClientStatus.PROJECT_NOT_REGISTERED, String.format("Committing project '%s' failed because of HTTP error.", name), e);
        }
    }
}

