/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.net;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class URLHolder {
    private String url;
    private static String Encoding = "UTF-8";

    public URLHolder() {
        this.url = "";
    }

    public URLHolder(String base) {
        this.url = base;
    }

    public void setBaseUrl(String base) {
        this.url = base;
    }

    public Builder build() {
        int length = this.url.length();
        if (length > 0 && this.url.charAt(length - 1) == '/') {
            return new Builder(this.url.substring(0, length - 1));
        }
        return new Builder(this.url);
    }

    public static class Builder {
        private StringBuffer buf;
        private UnsupportedEncodingException ex = null;

        public Builder(String base) {
            this.buf = new StringBuffer(base);
        }

        public String toUrl() {
            if (this.ex == null) {
                return this.buf.toString();
            }
            throw new InternalError(String.format("'%s' is unsupported encoding method.", Encoding));
        }

        public Builder append(String elem) {
            return this.append(elem, false);
        }

        public Builder append(String elem, boolean encode) {
            try {
                return this.ex == null ? this._append(elem, encode) : this;
            }
            catch (UnsupportedEncodingException e) {
                this.ex = e;
                return this;
            }
        }

        public Builder append(short elem) {
            return this.append(elem, false);
        }

        public Builder append(short elem, boolean encode) {
            try {
                return this.ex == null ? this._append(elem, encode) : this;
            }
            catch (UnsupportedEncodingException e) {
                this.ex = e;
                return this;
            }
        }

        public Builder append(int elem) {
            return this.append(elem, false);
        }

        public Builder append(int elem, boolean encode) {
            try {
                return this.ex == null ? this._append(elem, encode) : this;
            }
            catch (UnsupportedEncodingException e) {
                this.ex = e;
                return this;
            }
        }

        public Builder append(long elem) {
            return this.append(elem, false);
        }

        public Builder append(long elem, boolean encode) {
            try {
                return this.ex == null ? this._append(elem, encode) : this;
            }
            catch (UnsupportedEncodingException e) {
                this.ex = e;
                return this;
            }
        }

        public Builder append(float elem) {
            return this.append(elem, false);
        }

        public Builder append(float elem, boolean encode) {
            try {
                return this.ex == null ? this._append(elem, encode) : this;
            }
            catch (UnsupportedEncodingException e) {
                this.ex = e;
                return this;
            }
        }

        public Builder append(double elem) {
            return this.append(elem, false);
        }

        public Builder append(double elem, boolean encode) {
            try {
                return this.ex == null ? this._append(elem, encode) : this;
            }
            catch (UnsupportedEncodingException e) {
                this.ex = e;
                return this;
            }
        }

        public Builder append(Object elem) {
            return this.append(elem, false);
        }

        public Builder append(Object elem, boolean encode) {
            try {
                return this.ex == null ? this._append(elem, encode) : this;
            }
            catch (UnsupportedEncodingException e) {
                this.ex = e;
                return this;
            }
        }

        private Builder _append(String elem, boolean encode) throws UnsupportedEncodingException {
            this.buf.append('/').append(encode ? URLEncoder.encode(elem, Encoding) : elem);
            return this;
        }

        private Builder _append(short elem, boolean encode) throws UnsupportedEncodingException {
            this.buf.append('/').append(encode ? URLEncoder.encode(String.valueOf(elem), Encoding) : Short.valueOf(elem));
            return this;
        }

        private Builder _append(int elem, boolean encode) throws UnsupportedEncodingException {
            this.buf.append('/').append(encode ? URLEncoder.encode(String.valueOf(elem), Encoding) : Integer.valueOf(elem));
            return this;
        }

        private Builder _append(long elem, boolean encode) throws UnsupportedEncodingException {
            this.buf.append('/').append(encode ? URLEncoder.encode(String.valueOf(elem), Encoding) : Long.valueOf(elem));
            return this;
        }

        private Builder _append(float elem, boolean encode) throws UnsupportedEncodingException {
            this.buf.append('/').append(encode ? URLEncoder.encode(String.valueOf(elem), Encoding) : Float.valueOf(elem));
            return this;
        }

        private Builder _append(double elem, boolean encode) throws UnsupportedEncodingException {
            this.buf.append('/').append(encode ? URLEncoder.encode(String.valueOf(elem), Encoding) : Double.valueOf(elem));
            return this;
        }

        private Builder _append(Object elem, boolean encode) throws UnsupportedEncodingException {
            this.buf.append('/').append(encode ? URLEncoder.encode(String.valueOf(elem), Encoding) : elem);
            return this;
        }
    }
}

