/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.shared;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.ac.nii.hcp.client.net.URLHolder;

public class ClientConfiguration {
    private static final String HCP_CONSUMER_KEY = "";
    private static final String HCP_CONSUMER_SECRET = "hcp.consumer.secret";
    private static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    private URLHolder imageServerUrl;
    private URLHolder hcpAuthUrl;
    private URLHolder hcpRepositoryUrl;

    public ClientConfiguration() {
        ResourceBundle bundle = ResourceBundle.getBundle("hcp-url");
        try {
            this.hcpRepositoryUrl = new URLHolder(bundle.getString("hcp.repository"));
            this.hcpAuthUrl = new URLHolder(bundle.getString("hcp.auth"));
            this.imageServerUrl = new URLHolder(bundle.getString("hcp.image_server"));
        }
        catch (MissingResourceException e) {
            this.hcpRepositoryUrl = new URLHolder("http://hcp.nii.ac.jp:8080/api");
            this.hcpAuthUrl = new URLHolder("http://hcp.nii.ac.jp:8080/auth");
            this.imageServerUrl = new URLHolder("http://hcp.nii.ac.jp/imageServer");
        }
    }

    public URLHolder.Builder repositoryAPIURL() {
        return this.hcpRepositoryUrl.build();
    }

    public URLHolder.Builder imageServerURL() {
        return this.imageServerUrl.build();
    }

    public void repositoryAPIURL(String url) {
        this.hcpRepositoryUrl.setBaseUrl(url);
    }

    public void authURL(String url) {
        this.hcpAuthUrl.setBaseUrl(url);
    }

    public void imageServerURL(String url) {
        this.imageServerUrl.setBaseUrl(url);
    }

    public String authCheckURL() {
        return this.hcpAuthUrl.build().append("check").toUrl();
    }

    public String requestTokenRequestURL() {
        return this.hcpAuthUrl.build().append("request").toUrl();
    }

    public String requestTokenAuthorizeURL() {
        return this.hcpAuthUrl.build().append("login").toUrl();
    }

    public String accessTokenRequestURL() {
        return this.hcpAuthUrl.build().append("access").toUrl();
    }

    public String logoutURL() {
        return this.hcpAuthUrl.build().append("logout").toUrl();
    }

    public String consumerKey() {
        return HCP_CONSUMER_KEY;
    }

    public String consumerSecret() {
        return HCP_CONSUMER_SECRET;
    }

    public String signatureMethod() {
        return OAUTH_SIGNATURE_METHOD;
    }
}

