/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.workspace;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.ac.nii.hcp.client.module.ModelUtility;
import jp.ac.nii.hcp.client.module.ProjectContentProcessor;
import jp.ac.nii.hcp.client.module.ProjectProcessor;
import jp.ac.nii.hcp.client.workspace.AbstractWorkspace;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.ProjectDifference;
import jp.ac.nii.hcp.shared.module.BaseProcessor;

public class ProjectSpace
extends AbstractWorkspace {
    private static final String DB_FILE = "project.db";
    private static final String ATTACHMENT_DIR = "attachment";
    private Connection db;
    private File attachmentDir;

    public ProjectSpace(File root) {
        super(root);
        this.attachmentDir = new File(this.root, ATTACHMENT_DIR);
    }

    public static ProjectSpace create(File root, HCPProject project, boolean original) throws SQLException {
        ProjectSpace space = new ProjectSpace(root);
        space.initialize(project, original);
        return space;
    }

    private void initialize(HCPProject project, boolean original) throws SQLException {
        this.attachmentDir.mkdir();
        if (project != null) {
            ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
            try {
                processor.importProject(project, original);
                this.db.commit();
            }
            catch (SQLException e) {
                this.db.rollback();
            }
        }
    }

    public String getName() {
        return this.root.getName();
    }

    public void setName(String name) throws SQLException {
        ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        try {
            processor.changeName(name);
            this.db.commit();
        }
        catch (SQLException e) {
            this.db.rollback();
            throw e;
        }
    }

    public void dispose() {
        if (this.db != null) {
            try {
                try {
                    this.db.close();
                }
                catch (SQLException sQLException) {
                    this.db = null;
                }
            }
            finally {
                this.db = null;
            }
        }
    }

    public HCPProject getProject() throws SQLException {
        ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        HCPProject project = processor.get();
        if (project != null) {
            ProjectContentProcessor contentProcessor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
            project.materials = contentProcessor.getMaterials();
            project.documents = contentProcessor.getDocuments();
            project.attachments = contentProcessor.getAttachments();
        }
        return project;
    }

    public boolean isOriginal() throws SQLException {
        ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        HCPProject project = processor.get();
        return ModelUtility.isOriginal(project);
    }

    public HCPProjectContent getContent(String id) throws SQLException {
        ProjectContentProcessor processor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        HCPProjectContent.ContentType type = processor.getType(id);
        switch (type) {
            case MATERIAL: {
                return processor.getMaterial(id);
            }
            case DOCUMENT: {
                return processor.getDocument(id);
            }
            case ATTACHMENT: {
                return processor.getAttachment(id);
            }
        }
        return null;
    }

    public Collection<HCPProjectContent> updateProject(HCPProject project, Set<String> ids, boolean overwrite) throws SQLException {
        ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        try {
            processor.apply(project);
            ProjectContentProcessor contentProcessor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
            HashMap<Integer, HCPMaterial> repContents = new HashMap<Integer, HCPMaterial>();
            for (HCPMaterial content : project.materials) {
                repContents.put(content.sequence, content);
            }
            for (HCPMaterial content : project.documents) {
                repContents.put(content.sequence, content);
            }
            for (HCPMaterial content : project.attachments) {
                repContents.put(content.sequence, content);
            }
            ArrayList<HCPProjectContent> failed = new ArrayList<HCPProjectContent>();
            ArrayList<HCPProjectContent> toUpdate = new ArrayList<HCPProjectContent>();
            ArrayList<HCPProjectContent> toDelete = new ArrayList<HCPProjectContent>();
            HashSet<String> wsIds = new HashSet<String>();
            List<HCPProjectContent> contents = contentProcessor.listContents();
            for (HCPProjectContent content : contents) {
                HCPProjectContent repContent = (HCPProjectContent)repContents.get(content.sequence);
                wsIds.add(content.id);
                repContents.remove(content.sequence);
                if (ids != null && !ids.contains(content.id)) continue;
                ProjectContentProcessor.Status status = contentProcessor.getStatus(content.id);
                if (repContent != null) {
                    if (content.record.revision >= repContent.record.revision || status == ProjectContentProcessor.Status.ADDED) continue;
                    if (status == ProjectContentProcessor.Status.MODIFIED) {
                        if (overwrite) {
                            toUpdate.add(repContent);
                            continue;
                        }
                        failed.add(content);
                        continue;
                    }
                    if (status == ProjectContentProcessor.Status.DELETED) {
                        if (overwrite) {
                            toUpdate.add(repContent);
                            continue;
                        }
                        failed.add(content);
                        continue;
                    }
                    toUpdate.add(repContent);
                    continue;
                }
                if (status == ProjectContentProcessor.Status.ADDED) continue;
                if (status == ProjectContentProcessor.Status.MODIFIED) {
                    if (overwrite) {
                        toDelete.add(content);
                        continue;
                    }
                    failed.add(content);
                    continue;
                }
                if (status == ProjectContentProcessor.Status.DELETED) {
                    toDelete.add(content);
                    continue;
                }
                toDelete.add(content);
            }
            if (toDelete.size() > 0) {
                List<String> files = contentProcessor.deleteContents(toDelete);
                for (String path : files) {
                    this.removeAttachmentFile(path);
                }
            }
            for (HCPProjectContent content : toUpdate) {
                if (content instanceof HCPMaterial) {
                    contentProcessor.updateMaterial((HCPMaterial)content);
                    continue;
                }
                if (content instanceof HCPDocument) {
                    contentProcessor.updateDocument((HCPDocument)content);
                    continue;
                }
                if (!(content instanceof HCPAttachment)) continue;
                contentProcessor.updateAttachment((HCPAttachment)content);
            }
            if (ids == null) {
                for (HCPProjectContent content : repContents.values()) {
                    HCPProjectContent.ContentType type = contentProcessor.getType(content.id);
                    if (type != null) {
                        if (overwrite) {
                            switch (type) {
                                case MATERIAL: {
                                    contentProcessor.deleteMaterial(content.id);
                                    break;
                                }
                                case DOCUMENT: {
                                    contentProcessor.deleteDocument(content.id);
                                    break;
                                }
                                case ATTACHMENT: {
                                    contentProcessor.deleteAttachment(content.id);
                                }
                            }
                        } else {
                            switch (type) {
                                case MATERIAL: {
                                    failed.add((HCPProjectContent)contentProcessor.getMaterial(content.id));
                                    break;
                                }
                                case DOCUMENT: {
                                    failed.add((HCPProjectContent)contentProcessor.getDocument(content.id));
                                    break;
                                }
                                case ATTACHMENT: {
                                    failed.add((HCPProjectContent)contentProcessor.getAttachment(content.id));
                                }
                            }
                            continue;
                        }
                    }
                    if (content instanceof HCPMaterial) {
                        contentProcessor.registerMaterial((HCPMaterial)content);
                        continue;
                    }
                    if (content instanceof HCPDocument) {
                        contentProcessor.registerDocument((HCPDocument)content);
                        continue;
                    }
                    if (!(content instanceof HCPAttachment)) continue;
                    contentProcessor.registerAttachment((HCPAttachment)content);
                }
            }
            this.db.commit();
            return failed;
        }
        catch (SQLException e) {
            this.db.rollback();
            throw e;
        }
    }

    public ProjectDifference getDifference() throws SQLException {
        ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        HCPProject project = processor.get();
        ProjectDifference diff = new ProjectDifference(project.revision);
        ProjectContentProcessor contentProcessor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        contentProcessor.getAddedMaterials(diff.added);
        contentProcessor.getAddedDocuments(diff.added);
        contentProcessor.getAddedAttachments(diff.added);
        contentProcessor.getModifiedMaterials(diff.modified);
        contentProcessor.getModifiedDocuments(diff.modified);
        contentProcessor.getModifiedAttachments(diff.modified);
        contentProcessor.getDeletedMaterials(diff.deleted);
        contentProcessor.getDeletedDocuments(diff.deleted);
        contentProcessor.getDeletedAttachments(diff.deleted);
        return diff;
    }

    public HCPProjectContent.ContentType getType(String id) throws SQLException {
        ProjectContentProcessor processor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        return processor.getType(id);
    }

    public ProjectContentProcessor.Status getStatus(String id) throws SQLException {
        ProjectContentProcessor processor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        return processor.getStatus(id);
    }

    public void applyCommit(ProjectDifference diff) throws SQLException {
        try {
            ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
            processor.apply(diff);
            ProjectContentProcessor contentProcessor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
            for (HCPProjectContent content : diff.added) {
                contentProcessor.applyCommit(content.id, content, ProjectContentProcessor.Status.ADDED);
            }
            for (HCPProjectContent content : diff.modified) {
                contentProcessor.applyCommit(content.id, content, ProjectContentProcessor.Status.MODIFIED);
            }
            for (HCPProjectContent content : diff.deleted) {
                contentProcessor.applyCommit(content.id, content, ProjectContentProcessor.Status.DELETED);
            }
            this.db.commit();
        }
        catch (SQLException e) {
            this.db.rollback();
            throw e;
        }
    }

    public void applyCommit(String id, HCPProjectContent content, ProjectContentProcessor.Status status) throws SQLException {
        ProjectContentProcessor processor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        try {
            processor.applyCommit(id, content, status);
            this.db.commit();
        }
        catch (SQLException e) {
            this.db.rollback();
            throw e;
        }
    }

    public void applyImport(HCPProject project) throws SQLException {
        ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        try {
            processor.apply(project);
            ProjectContentProcessor contentProcessor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.db, (Object[])new Object[0]);
            for (HCPProjectContent c : project.materials) {
                contentProcessor.applyContent(c);
            }
            for (HCPProjectContent c : project.documents) {
                contentProcessor.applyContent(c);
            }
            for (HCPProjectContent c : project.attachments) {
                contentProcessor.applyContent(c);
            }
        }
        catch (SQLException e) {
            this.db.rollback();
            throw e;
        }
    }

    public boolean hasAttachmentFile(HCPAttachment attachment) {
        if (attachment.filePath != null && attachment.filePath.length() > 0) {
            File attachmentFile = new File(this.attachmentDir, attachment.filePath);
            return attachmentFile.exists();
        }
        return false;
    }

    public void addFileAttachment(ProjectDifference diff, InputStream entity) throws IOException, SQLException {
        HCPAttachment attachment = (HCPAttachment)diff.added.get(0);
        ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        try {
            processor.apply(diff);
            ProjectContentProcessor contentProcessor = (ProjectContentProcessor)BaseProcessor.getProcessor(ProjectContentProcessor.class, (Connection)this.db, (Object[])new Object[0]);
            contentProcessor.registerAttachment(attachment);
            this.db.commit();
        }
        catch (SQLException e) {
            this.db.rollback();
            throw e;
        }
        this.saveAttachmentFile(attachment, entity);
    }

    public void saveAttachmentFile(HCPAttachment attachment, InputStream entity) throws IOException {
        File attachmentFile = this.getAttachmentFile(attachment);
        File dirPath = attachmentFile.getParentFile();
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(attachmentFile);
        int bytes = 0;
        byte[] buf = new byte[4096];
        while ((bytes = entity.read(buf)) >= 0) {
            out.write(buf, 0, bytes);
        }
        out.close();
    }

    public File getAttachmentFile(HCPAttachment attachment) {
        if (attachment.isFile()) {
            return new File(this.attachmentDir, attachment.filePath);
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        if (this.db == null) {
            this.setupConnection();
        }
        return this.db;
    }

    private void setupConnection() throws SQLException {
        String dbFilePath = this.getDatabase();
        boolean exists = new File(dbFilePath).exists();
        String dsn = "jdbc:sqlite://" + dbFilePath;
        this.db = DriverManager.getConnection(dsn);
        this.db.setAutoCommit(false);
        this.db.rollback();
        if (!exists) {
            this.initializeDatabase();
        }
    }

    private String getDatabase() {
        return new File(this.root, DB_FILE).getAbsolutePath();
    }

    public void removeAttachmentFile(String path) {
        File attachmentFile = new File(this.attachmentDir, path);
        if (attachmentFile.exists()) {
            attachmentFile.delete();
        }
    }

    private void initializeDatabase() throws SQLException {
        ProjectProcessor processor = (ProjectProcessor)BaseProcessor.getProcessor(ProjectProcessor.class, (Connection)this.getConnection(), (Object[])new Object[0]);
        try {
            processor.createSchema();
            this.db.commit();
        }
        catch (SQLException e) {
            this.db.rollback();
        }
    }
}

