/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ac.nii.hcp.client.workspace.AbstractWorkspace;
import jp.ac.nii.hcp.client.workspace.ProjectSpace;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;

public class RepositorySpace
extends AbstractWorkspace {
    private Map<String, ProjectSpace> spaces;

    public static RepositorySpace get(File root) {
        RepositorySpace space = new RepositorySpace(root);
        if (space.validate()) {
            space.initialize();
            return space;
        }
        return null;
    }

    public RepositorySpace(File root) {
        super(root);
    }

    private void initialize() {
        File[] files = this.root.listFiles();
        this.spaces = new HashMap<String, ProjectSpace>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory()) {
                this.spaces.put(dir.getName(), new ProjectSpace(dir));
            }
            ++n2;
        }
    }

    public boolean hasProject(String name) {
        return this.spaces.containsKey(name);
    }

    public ProjectSpace getProjectSpace(String name) {
        return this.spaces.get(name);
    }

    public HCPProject getProject(String name) throws SQLException {
        if (this.spaces.containsKey(name)) {
            return this.spaces.get(name).getProject();
        }
        return null;
    }

    public List<HCPProject> listProjects() {
        ArrayList<HCPProject> projects = new ArrayList<HCPProject>();
        for (ProjectSpace space : this.spaces.values()) {
            try {
                HCPProject project = space.getProject();
                if (project == null) continue;
                projects.add(project);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return projects;
    }

    public HCPProject createProject(HCPProject project, boolean original) throws SQLException {
        if (!this.spaces.containsKey(project.name)) {
            File projectDir = new File(this.root, project.name);
            projectDir.mkdir();
            ProjectSpace projectSpace = ProjectSpace.create(projectDir, project, original);
            this.spaces.put(project.name, projectSpace);
            return projectSpace.getProject();
        }
        return null;
    }

    public Collection<HCPProjectContent> updateProject(String name, HCPProject project, Set<String> ids, boolean overwrite) throws SQLException {
        if (this.spaces.containsKey(project.name)) {
            ProjectSpace projectSpace = this.spaces.get(project.name);
            return projectSpace.updateProject(project, ids, overwrite);
        }
        return null;
    }

    public void removeProject(String name) {
        if (this.spaces.containsKey(name)) {
            this.spaces.get(name).dispose();
            File projectDir = new File(this.root, name);
            this.clearDirectory(projectDir);
            projectDir.delete();
            this.spaces.remove(name);
        }
    }

    public void renameProject(String name, String newName) throws IOException, SQLException {
        File oldDir = new File(this.root, name);
        File newDir = new File(this.root, newName);
        ProjectSpace oldSpace = this.spaces.get(name);
        HCPProject project = oldSpace.getProject();
        newDir.mkdir();
        ProjectSpace newSpace = ProjectSpace.create(newDir, project, false);
        for (HCPAttachment attachment : project.attachments) {
            File af = oldSpace.getAttachmentFile(attachment);
            if (af == null || !af.exists()) continue;
            FileInputStream entity = new FileInputStream(af);
            newSpace.saveAttachmentFile(attachment, entity);
            ((InputStream)entity).close();
        }
        newSpace.setName(newName);
        this.spaces.put(newName, newSpace);
        oldSpace.dispose();
        this.clearDirectory(oldDir);
        oldDir.delete();
        this.spaces.remove(name);
    }
}

