/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.FocusPolicyMemento;
import com.jeta.forms.store.memento.FormGroupSet;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.support.Matrix;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class FormMemento
extends ComponentMemento
implements Externalizable {
    static final long serialVersionUID = -7808404997780438089L;
    public static final int VERSION = 5;
    private String m_row_specs;
    private String m_column_specs;
    private LinkedList m_components = new LinkedList();
    private PropertiesMemento m_properties_memento;
    private String m_path;
    private String m_id;
    private Matrix m_cell_painters;
    private FormGroupSet m_row_groups;
    private FormGroupSet m_column_groups;
    private FocusPolicyMemento m_focus_policy;
    private HashMap m_properties = new HashMap();

    public void addComponent(ComponentMemento componentMemento) {
        this.m_components.add(componentMemento);
    }

    public Matrix getCellPainters() {
        return this.m_cell_painters;
    }

    public FormGroupSet getColumnGroups() {
        return this.m_column_groups;
    }

    public String getColumnSpecs() {
        return this.m_column_specs;
    }

    public FocusPolicyMemento getFocusPolicy() {
        return this.m_focus_policy;
    }

    public String getId() {
        return this.m_id;
    }

    public PropertiesMemento getPropertiesMemento() {
        return this.m_properties_memento;
    }

    public HashMap getProperties() {
        return this.m_properties;
    }

    public String getRelativePath() {
        return this.m_path;
    }

    public FormGroupSet getRowGroups() {
        return this.m_row_groups;
    }

    public String getRowSpecs() {
        return this.m_row_specs;
    }

    public Iterator iterator() {
        return this.m_components.iterator();
    }

    public void print() {
        System.out.println(" >>>>>>>>>>>>>>>>>  FormMemento state >>>>>>>>>>>>>> ");
        System.out.println("rowSpecs: " + this.m_row_specs);
        System.out.println("colSpecs: " + this.m_column_specs);
        System.out.println(" ----------- comp mementos --------- ");
        Iterator iterator = this.m_components.iterator();
        while (iterator.hasNext()) {
            ComponentMemento componentMemento = (ComponentMemento)iterator.next();
            componentMemento.print();
        }
    }

    public void setCellPainters(Matrix matrix) {
        this.m_cell_painters = matrix;
    }

    public void setColumnGroups(FormGroupSet formGroupSet) {
        this.m_column_groups = formGroupSet;
    }

    public void setColumnSpecs(String string) {
        this.m_column_specs = string;
    }

    public void setFocusPolicy(FocusPolicyMemento focusPolicyMemento) {
        this.m_focus_policy = focusPolicyMemento;
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public void setRelativePath(String string) {
        this.m_path = string;
    }

    public void setRowGroups(FormGroupSet formGroupSet) {
        this.m_row_groups = formGroupSet;
    }

    public void setProperties(HashMap hashMap) {
        this.m_properties = hashMap;
    }

    public void setPropertiesMemento(PropertiesMemento propertiesMemento) {
        this.m_properties_memento = propertiesMemento;
    }

    public void setRowSpecs(String string) {
        this.m_row_specs = string;
    }

    public int size() {
        return this.m_components.size();
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_id = (String)objectInput.readObject();
        this.m_path = (String)objectInput.readObject();
        if (FormUtils.isDesignMode()) {
            this.m_path = FormUtils.fixPath(this.m_path);
        }
        this.m_row_specs = (String)objectInput.readObject();
        this.m_column_specs = (String)objectInput.readObject();
        this.m_components = (LinkedList)objectInput.readObject();
        if (n >= 5) {
            this.m_properties_memento = (PropertiesMemento)objectInput.readObject();
        } else {
            this.m_properties = (HashMap)objectInput.readObject();
        }
        if (n >= 2) {
            this.m_cell_painters = (Matrix)objectInput.readObject();
        }
        if (n >= 3) {
            this.m_focus_policy = (FocusPolicyMemento)objectInput.readObject();
            this.m_focus_policy = null;
        }
        if (n >= 4) {
            this.m_row_groups = (FormGroupSet)objectInput.readObject();
            this.m_column_groups = (FormGroupSet)objectInput.readObject();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(5);
        objectOutput.writeObject(this.m_id);
        objectOutput.writeObject(this.m_path);
        objectOutput.writeObject(this.m_row_specs);
        objectOutput.writeObject(this.m_column_specs);
        objectOutput.writeObject(this.m_components);
        objectOutput.writeObject(this.m_properties_memento);
        objectOutput.writeObject(this.m_cell_painters);
        objectOutput.writeObject(this.m_focus_policy);
        objectOutput.writeObject(this.m_row_groups);
        objectOutput.writeObject(this.m_column_groups);
    }
}

