/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.util.Collection;
import java.util.Vector;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.util.XMLPrinter;

public class PropertyBodyHelper {
    protected PropertyName[] propertyNames;

    protected void setPropertyNames(Collection propertyNames) {
        Vector list = new Vector();
        for (Object item : propertyNames) {
            if (item instanceof PropertyName) {
                list.add(item);
                continue;
            }
            if (!(item instanceof String)) continue;
            String propertyName = (String)item;
            int length = propertyName.length();
            boolean found = false;
            int i = 1;
            while (!found && i <= length) {
                char chr = propertyName.charAt(length - i);
                if (!Character.isUnicodeIdentifierPart(chr) && chr != '-' && chr != '_' && chr != '.') {
                    found = true;
                    continue;
                }
                ++i;
            }
            if (i == 1 || i >= length) {
                list.add(new PropertyName("DAV:", propertyName));
                continue;
            }
            String namespace = propertyName.substring(0, length + 1 - i);
            String localName = propertyName.substring(length + 1 - i);
            list.add(new PropertyName(namespace, localName));
        }
        this.propertyNames = list.toArray(new PropertyName[list.size()]);
    }

    protected void wirtePropElement(XMLPrinter printer) {
        if (this.propertyNames != null) {
            printer.writeElement("D", "prop", 0);
            for (int i = 0; i < this.propertyNames.length; ++i) {
                String namespace = this.propertyNames[i].getNamespaceURI();
                String localname = this.propertyNames[i].getLocalName();
                if ("DAV:".equals(namespace)) {
                    printer.writeElement("D", localname, 2);
                    continue;
                }
                printer.writeElement("ZZ", namespace, localname, 2);
            }
            printer.writeElement("D", "prop", 1);
        }
    }
}

