/* $Id: ExplanatoryNote.java 1072 2016-02-27 04:27:27Z shayashi $ */
/*
 * 作成日: 2006/06/02
 *
 */
package reasoning_web.logical;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.GSVersion;
import smart_gs.logical.GSResource;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.TextSegment;
import smart_gs.logical.URICreator;
import smart_gs.logical.URIObject;
import smart_gs.logical.visitor.Visitor;



/**
 * @author kazuaki kobayashi
 *
 * 
*/
public class ExplanatoryNote extends SmartDocument {

	private RWElement container;

	private String version;

	protected ExplanatoryNote(String source, String uri, String originalURI, String version){
		super(source);
		this.setId(this.hashCode());
		this.setURIs(uri, originalURI);
		this.version = version;
	}
	protected ExplanatoryNote(String source, int id, String uri, String originalURI, String version){
		super(source);
		this.setId(id);
		this.setURIs(uri, originalURI);
		this.version = version;
	}
	public ExplanatoryNote(String source) {
		super(source);
		this.setId(id);
		this.initializeURIs();
		this.version = GSVersion.getVersion();
	}


	public void accept(Visitor visitor) {

	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getTypeString() {
		return URICreator.EXPLANATORY_NOTE;
	}
	@Override
	public String getVersion() {
		return this.version;
	}
	@Override
	public void setVersion(String version) {
		this.version = version;		
	}
	public void appendContainer(RWElement container) {
		this.container = container;
	}
	@Override
	public String getOldVersionURI() {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public void setOldVersionURI(String oldVersionURI) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void makeItZombie() {
		// None	
	}
	@Override
	public boolean isZombie() {
		return false;
	}
	@Override
	public void resuscitate() {
		//None
	}

}