/* $Id: ImageSearchFilterImpl.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.dictionary.image;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

import smart_gs.dictionary.Dictionary;
import smart_gs.dictionary.DictionaryRegion;
import smart_gs.dictionary.DictionaryXML;
import smart_gs.image_search.ImageSearchFilter;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;

public class ImageSearchFilterImpl implements ImageSearchFilter{
	protected HashMap<String,ArrayList<FilterData>> urlMap = new HashMap<String, ArrayList<FilterData>>();
	
	public void init(){
		DictionaryXML dictionaryXML = DictionaryXML.getInstance();
//		dictionaryXML.load();
		TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
		Iterator<String> itr = dictionaryMap.keySet().iterator();
		while(itr.hasNext()){
			String word = itr.next();
			Dictionary dictionary = dictionaryMap.get(word);
			 ArrayList<DictionaryRegion>  dictionaryRegions =  dictionary.getDictionaryRegionList();
			 for(int i=0;i<dictionaryRegions.size();i++){
				 DictionaryRegion dictionaryRegion = dictionaryRegions.get(i);
				 if(urlMap.containsKey(dictionaryRegion.getRegion().getBaseURI())){
					 ArrayList<FilterData> dictionaryRegionList = urlMap.get(dictionaryRegion.getRegion().getBaseURI());
					 FilterData filterData = new FilterData();
					 filterData.setWord(word);
					 filterData.setDictionaryRegion(dictionaryRegion);
					 dictionaryRegionList.add(filterData);
				 }else{
					 ArrayList<FilterData> dictionaryRegionList = new ArrayList<FilterData>();
					 FilterData filterData = new FilterData();
					 filterData.setWord(word);
					 filterData.setDictionaryRegion(dictionaryRegion);
					 dictionaryRegionList.add(filterData);
					 urlMap.put(dictionaryRegion.getRegion().getBaseURI(), dictionaryRegionList);
				 }
			 }
		}
	}
	
	public SearchResult filter(SearchResult searchResult) {
		try{
			String uri = searchResult.getBaseURI();
			if(urlMap.containsKey(uri)){
				ArrayList<FilterData> dictionaryRegions = urlMap.get(uri);
				for(int i=0;i<dictionaryRegions.size();i++){
					FilterData  filterData = dictionaryRegions.get(i);
					DictionaryRegion dictionaryRegion = filterData.getDictionaryRegion();
					{
						Region region = dictionaryRegion.getRegion();
						Rectangle rectangle = region.getRectangle();
						boolean match = contains(searchResult.getRectangle(),region.getRectangle());
						if(match){
							SearchDictionaryResult searchDictionaryResult = new SearchDictionaryResult(searchResult.getSpread(),rectangle,searchResult.getScore(),searchResult.getRank(),searchResult.getLineIndex());
							searchDictionaryResult.setWord(filterData.getWord());
							return searchDictionaryResult;
						}
					}
				}
			}
		}catch(Exception e){
			
		}
		return null;
//		return searchResult;
	}
	public boolean contains(Rectangle a,Rectangle b){
		return true;
	} 

	class FilterData{
		protected String word;
		protected DictionaryRegion dictionaryRegion;
		
		public DictionaryRegion getDictionaryRegion() {
			return dictionaryRegion;
		}
		public void setDictionaryRegion(DictionaryRegion dictionaryRegion) {
			this.dictionaryRegion = dictionaryRegion;
		}
		public String getWord() {
			return word;
		}
		public void setWord(String word) {
			this.word = word;
		}
	}
}
