package smart_gs.drawing_tool;

import java.awt.Image;
import java.awt.Point;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorDrawPolygonMode;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;


@SuppressWarnings("serial")
public class LineSegEditorCanvas extends JScrollPane {

	private Spread spread;
	private LineSegEditorImageLabel lsgImageLabel;
	private ImageIcon imageIcon;
	
	public LineSegEditorCanvas(Spread spread, LineSegEditor lineSegEditor) {
		super();
		this.getVerticalScrollBar().setUnitIncrement(20);
		this.getHorizontalScrollBar().setUnitIncrement(20);
		this.spread = spread;
		this.imageIcon = spread.getImageIcon();
		this.lsgImageLabel = new LineSegEditorImageLabel(this,imageIcon,lineSegEditor);
		this.setViewportView(this.lsgImageLabel);
	}
	
	public LineSegEditorCanvas(Spread spread, Image image, LineSegEditor lineSegEditor, List<LineSegmentForEdit> lines) {
		super();
		this.getVerticalScrollBar().setUnitIncrement(20);
		this.getHorizontalScrollBar().setUnitIncrement(20);
		this.spread = spread;
		this.imageIcon = new ImageIcon(image);
		this.lsgImageLabel = new LineSegEditorImageLabel(this,imageIcon,lineSegEditor, lines);
		this.setViewportView(this.lsgImageLabel);
	}
	
	public void resetLineSegEditorCanvas(Spread spread, Image image, LineSegEditor lineSegEditor, List<LineSegmentForEdit> lines) {
		this.spread = spread;
		this.imageIcon = new ImageIcon(image);
		this.lsgImageLabel.resetLineSegEditorImageLabel(imageIcon, lines);
		this.setViewportView(this.lsgImageLabel);
		this.repaint();
	}
	
	
	public Point getCornerPoint(){
		return this.getCornerPoint();
	}

	public Spread getSpread(){
		return this.spread;
	}
	

	public LineSegEditorImageLabel getLineSegEditorImageLabel(){
		return this.lsgImageLabel;
	}

	public void addTempView(View view){
		this.lsgImageLabel.addTempView(view);
	}
	public void zoomIn() {
		this.lsgImageLabel.zoomIn();
	}
	public void zoomOut(){
		this.lsgImageLabel.zoomOut();
	}

	public void fullSize() {
		this.lsgImageLabel.fullSize();
	}

	public void fitWidth() {
		this.lsgImageLabel.fitWidth(this.getWidth());
	}

	public void fitHeight() {
		this.lsgImageLabel.fitHeight(this.getHeight());
	}

	
	public void setCenterLocation(Point point){
		this.lsgImageLabel.setCenterLocation(point);
	}

	public void clear() {
		this.getViewport().removeAll();	
		this.getCurrentSpread().release();
	}

	public void setCurrentSpread(Spread currentSpread) {
		this.spread = currentSpread;
	}
	public Spread getCurrentSpread() {
		return spread;
	}
	
	public List<LineSegmentForEdit> getLines() {
		return this.getLineSegEditorImageLabel().getLines();
	}


	/**
	 * @param lines the lines to set
	 */
	public void setLinesForEdit(List<LineSegmentForEdit> lines) {
		this.getLineSegEditorImageLabel().setLines(lines);
	}

	public void rewriteLineSegIndexes() {
		this.getLineSegEditorImageLabel().rewriteLinesSegIndexes();
	}

	public void addLineSegmentForEdit(LineSegmentForEdit LineSegmentForEdit) {
		this.getLineSegEditorImageLabel().addLineSegmentForEdit(LineSegmentForEdit);
	}

	public ImageIcon getImageIcon() {
		return this.imageIcon;
	}

	public LineSegEditorImageLabel getLsgImageLabel() {
		// TODO Auto-generated method stub
		return this.lsgImageLabel;
	}

	public void setPosition(int pos) {
		JViewport vp = this.getViewport();
		if (pos == GSConstants.TOP_LEFT) {
			vp.setViewPosition(new Point(0,0));
		}
		if (pos == GSConstants.TOP_RIGHT) {
			vp.setViewPosition(new Point(imageIcon.getIconWidth(),0));
		}
	}	
	
}
