package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.RegionOperation;
import smart_gs.logical.Spread;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Pair;

public class BookmarkChangeColorAction implements ActionListener {

	private View view;
	private String new_color;
	private Region region;
	private BookmarkRegion bookmark;
	
	public BookmarkChangeColorAction(Region region, String colorPath) {
		if (region instanceof BookmarkRegion) {
			this.bookmark = (BookmarkRegion)region;
			this.view = region.getView();
			this.region = region;
			this.new_color = colorPath;
		}
	}
	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (this.view instanceof BookmarkView) {
			Spread spread = this.bookmark.getSpread();
			String old_color = ((BookmarkView)this.view).getColorPath();
			spread.pushRegionUndoStack(new RegionOperation(RegionOperation.CHANGE_BOOKMARK_COLOR, this.bookmark, new Pair<String,String>(old_color,new_color),spread));
			((BookmarkView)this.view).setColorPath(new_color);
			WorkspaceWindow.getInstance().repaint();
		}

	}

}
