/* $Id: ReleaseProtectedRegionAction.java 1058 2016-01-17 17:09:20Z shayashi $ */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.logical.Region;
import smart_gs.logical.RegionOperation;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Pair;

public class ReleaseProtectedRegionAction implements ActionListener {
	private Region region;
	public ReleaseProtectedRegionAction(Region region){
		this.region = region;
	}
	
	public void execute(){
//		region.getSpread().getCurrentSheet().releaseRegion(region);
//		region.releaseProtection();
		if(this.region != null){
			Spread spread = region.getSpread();
			spread.pushRegionUndoStack(new RegionOperation(RegionOperation.RELEASE, this.region,  this.region,spread));

			region.setProtection(Region.NORMAL);
			region.getView().setIsProtected(Region.NORMAL);
			WorkspaceWindow.setUpdated(true);
		}
	}
	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub
		this.execute();
	}

}
