package smart_gs.drawing_tool.drawing_mode;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.util.GSLog;
import smart_gs.util.Intersection2D;
import sml_editor.logical.LineDirection;

public class LineSegEditorDeleterMode implements LineSegEditorMode {
	
	private LineSegEditor editor;

	public LineSegEditor getEditor() {
		return this.editor; 
	}

	public LineSegEditorDeleterMode(LineSegEditor editor) {
		this.editor = editor;
	}

	public void LineSegEditorDeleteMode_LOOP() {}
	
	public void mousePressed(GSMouseEvent e, LineSegEditorCanvas canvas) {

	}
	
	public void mouseClicked(GSMouseEvent e,LineSegEditorCanvas canvas) {
		List<LineSegmentForEdit> lines = this.editor.getLinesForEdit();
		Point point = e.getPoint();
		for (int i=0; i<lines.size();i++) {
			if (lines.get(i).contains(point)) {
				this.editor.pushUndoStack();
				lines.remove(i);
				this.editor.setLinesForEdit(lines);
				this.editor.rewriteLineSegIndexes();
				this.editor.repaint();
				break;
			}
		}
	}
	

	public void mouseMoved(GSMouseEvent e,LineSegEditorCanvas canvas) {
		setCursor(canvas);

	}

	@Override
	public void paint(Graphics g,LineSegEditorCanvas canvas) {	
		
		setCursor(canvas);
	}
	
	public void cancel() {
		// TODO Auto-generated method stub
		
	}
	
	public void mouseDragged(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);		
	}
	
	public void mouseEntered(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);		
	}
	
	public void mouseExited(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);
		
	}
	
	public void mouseReleased(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);		
	}
	
	public void setCursor(LineSegEditorCanvas canvas) {
		Image img = new ImageIcon(GSConstants.ICON_PATH+"deleter.png").getImage();
		String name = "deleter_cursor";
		Toolkit kit = Toolkit.getDefaultToolkit();
		Cursor x = kit.createCustomCursor(img.getScaledInstance(60, 60, Image.SCALE_DEFAULT/2), new Point(20,20), name);
		canvas.getLineSegEditorImageLabel().setCursor(x);		
	}

	@Override
	public LineSegEditor getParentLinesegEditor() {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public void setParentLinesegEditor() {
		// TODO Auto-generated method stub
		
	}

}



