package smart_gs.drawing_tool.drawing_mode;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.view.CenterView;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.LineSegEditorRotationFrame;

public class LineSegEditorRotationMode implements LineSegEditorMode {

	private LineSegEditorRotationFrame frame;
	private CenterView center;

	public LineSegEditorRotationMode(LineSegEditor editor,LineSegEditorRotationFrame frame) {
		this.frame = frame;
	}

	@Override
	public void mouseClicked(GSMouseEvent e, LineSegEditorCanvas canvas) {
		this.frame.setCenterPoint(e.getX(),e.getY());
	}

	@Override
	public void mouseEntered(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseReleased(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseDragged(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseMoved(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void paint(Graphics g, LineSegEditorCanvas canvas) {
		double ratio = canvas.getLineSegEditorImageLabel().getRatio();
		double gapX = canvas.getLineSegEditorImageLabel().getGapWidth();
		double gapY = canvas.getLineSegEditorImageLabel().getGapHeight();
		int x = this.frame.getCenterX();
		int y = this.frame.getCenterY();
		if (x >= 0 & y>=0) {
			if (this.center != null) {
				this.center.enlargedView(ratio,gapX,gapY).draw((Graphics2D)g);
			} else {
				int offset = (GSConstants.ROTATION_CENTER_SIZE-1)/2;
				offset++;
				if (x >=0 && y >= 0)
					new CenterView(new Point(x,y),1).enlargedView(ratio,gapX,gapY).draw((Graphics2D)g);
			}

			setCursor(canvas);
		}
	}

	public void setCursor(LineSegEditorCanvas canvas) {
		canvas.getLineSegEditorImageLabel().setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));		
	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setParentLinesegEditor() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public LineSegEditor getParentLinesegEditor() {
		// TODO Auto-generated method stub
		return null;
	}
}
