package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import javax.swing.ImageIcon;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.logical.Preference;
import smart_gs.logical.URICreator;

public class CenterView extends View {
	
	static int iconsize = GSConstants.ROTATION_CENTER_SIZE;
	public static double DEFAULT_WIDTH = iconsize;
	public static double DEFAULT_HEIGHT = iconsize;
	
	private Rectangle2D rectangle;
	private double size;
	private Point origin;
	private double imageScale;
	private static int offset_x = -10;
	private static int offset_y = 23;

	
	public CenterView(Point origin, double size) {
		this.origin = origin;
		this.changeSize(size);
	}

	@Override
	protected void drawShape(Graphics2D g) {
		if (this.isSelected) {
			this.drawSelectedIcon(g);
		}

		ImageIcon imageIcon = new ImageIcon(
				GSConstants.ICON_PATH + "rotationCenter.png");
		Image image = imageIcon.getImage();
		int x = (int)this.rectangle.getX();
		int y = (int)this.rectangle.getY();
		int width = (int)this.rectangle.getWidth();
		int height = (int)this.rectangle.getHeight();
		g.drawImage(image, x+offset_x, y+offset_y, width, height, null);
		if (this.isProtected) {
			int xx = (int)this.rectangle.getX();
			int yy = (int)this.rectangle.getY();
			int ww = (int)(this.rectangle.getWidth() / 2);
			int hh = (int)(this.rectangle.getHeight());
			Rectangle rect = new Rectangle(xx, yy, ww, hh);
			g.setStroke(new BasicStroke(1));
			g.setColor(Color.BLACK);
			g.draw(rect);
		}
	}

	@Override
	public CenterView enlargedView(double ratio, double gapX, double gapY) {
		this.imageScale = ratio;
		int x = (int)(this.origin.getX() * ratio + gapX);
		int y = (int)(this.origin.getY() * ratio + gapY);
		Point newOrigin = new Point(x,y);
		CenterView view = new CenterView(newOrigin, this.size);
		view.setIsSelected(this.isSelected);
		view.isProtected = this.isProtected;
		return view;
	}

	@Override
	public Point getCenterPoint() {
		return new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
	}

	@Override
	public Rectangle2D getRectangle2D() {
		return this.rectangle;
	}

	@Override
	public int getType() {
		return View.CENTER;
	}

	@Override
	public String getTypeString() {
		return "";
	}

	@Override
	public void moveBy(Point2D d) {
		int x = (int)(this.origin.getX()+d.getX());
		int y = (int)(this.origin.getY()+d.getY());
		this.origin = new Point(x,y);
		this.changeSize(this.size);
	}

	@Override
	public String getTypeStringForDisplay() {
		return "CenterPoint";
	}
	public void changeSize(double size) {
		this.size = size;
		double originX = this.origin.getX();
		double originY = this.origin.getY();
		double w = DEFAULT_WIDTH * size;
		double h = DEFAULT_HEIGHT * size;
		double x = originX - (w/4);
		double y = originY - h;
		this.rectangle = new Rectangle2D.Double(x, y, w, h);
	}

	public double getSize() {
		return this.size;
	}

	@Override
	public void drawLinkIcon(Graphics2D g, Image image) {

	}

	@Override
	public void drawTemporaryIcon(Graphics2D g) {
	}


	@Override
	public void drawSelectedIcon(Graphics2D g) {	
	}

	@Override
	public boolean containsInCloseUpIcon(Point2D point) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	protected Rectangle closeUpImageRectangle() {
		// TODO Auto-generated method stub
		return null;
	
}

	@Override
	public boolean contains(Point2D point) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void drawLinkedShape(Graphics2D g, Image image) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void drawTemporaryShape(Graphics2D g) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Element createXMLElement(Document document) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void drawInBasketShape(Graphics2D g) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void drawRWShape(Graphics2D g) {
		// TODO Auto-generated method stub
		
	}
}