/* $Id: PolygonView.java 1012 2015-10-04 23:53:18Z minao $ */
package smart_gs.drawing_tool.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Point2D.Double;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.logical.URICreator;


public class PolygonView extends View{
	
	private List<LineView> lines;

	public PolygonView(){
		this.lines = new ArrayList<LineView>();
		this.defaultColor = Color.BLUE;
		this.selectionColor = Color.red;
	}
	public PolygonView(List<ExLine2D> exLines){
		super();
		this.lines = new ArrayList<LineView>();
		for(int i=0;i<exLines.size();i++){
			this.lines.add(new LineView(exLines.get(i)));
		}
		//added 2011.10.02 shayashi to close the polygon
		this.lines.add(new LineView(new ExLine2D(exLines.get(exLines.size()-1).getP2(),exLines.get(0).getP1())));
		this.defaultColor = Color.BLUE;
		this.selectionColor = Color.red;
	}
	
	public PolygonView(List<ExLine2D> lines,boolean isSelected,boolean isEmphasized, boolean isProtected) {
		this(lines);
		this.isSelected = isSelected;
		this.isEmphasized = isEmphasized;
//		this.defaultColor = Color.BLUE;
//		this.selectionColor = Color.red;
		this.isProtected = isProtected;
	}

	// changed 2011.01.02 shayashi
	@Override
	public boolean contains(Point2D point) {
		int xpoints[],  ypoints[];
		xpoints = new int[lines.size()];
		ypoints = new int[lines.size()];
		Polygon polygon;
		for(int i=0;i<this.lines.size();i++){
			xpoints[i] = (int)this.lines.get(i).getLine().getP1().getX();
			ypoints[i] = (int)this.lines.get(i).getLine().getP1().getY();
		}
		polygon = new Polygon(xpoints,ypoints,lines.size());
		return polygon.contains(point);
	}
	
	public void addLineView(LineView line){
		this.lines.add(line);
	}
	@Override
	public void drawShape(Graphics2D g) {
		if (this.isSelected) {
			this.drawSelectedIcon(g);
		}
		for(int i=0;i<this.lines.size();i++){
			this.lines.get(i).drawShape(g);
		}
	}

	@Override
	public int getType() {
		return View.POLYGON;
	}

	@Override
	public void moveBy(Point2D d) {
		for(int i=0;i<this.lines.size();i++){
			this.lines.get(i).moveBy(d);
		}
	}

	@Override
	public View enlargedView(double ratio, double gapX, double gapY) {
		List<ExLine2D> newLines = new ArrayList<ExLine2D>();
		for(int i=0;i<this.lines.size()-1;i++){
			LineView line = this.lines.get(i);
			line = (LineView)line.enlargedView(ratio,gapX,gapY);
			newLines.add(line.getLine());
		}
		return new PolygonView(newLines,this.isSelected,this.isEmphasized, this.isProtected);
	}
	@Override
	public Rectangle2D getRectangle2D() {
		LineView line1 = this.lines.get(0);
		double minX = line1.getMinX(),minY = line1.getMinY(),maxX = line1.getMaxX(),maxY = line1.getMaxY(); 
		for(int i=0;i<this.lines.size();i++){
			LineView line = this.lines.get(i);
			if(minX > line.getMinX() || minX == -1){
				minX = line.getMinX();
			}
			if(minY > line.getMinY() || minX == -1){
				minY = line.getMinY();
			}
			if(maxX < line.getMaxX() || minX == -1){
				maxX = line.getMaxX();
			}
			if(maxY < line.getMaxY() || minX == -1){
				maxY = line.getMaxY();
			}
		}
		
		return new Rectangle2D.Double(minX,minY,maxX-minX,maxY-minY);
	}
	@Override
	public String getTypeString() {
		return URICreator.POLYGON;
	}
	@Override
	public void drawLinkedShape(Graphics2D g, Image image) {
		this.draw(g);
		this.drawLinkIcon(g, image);
	}
	
	@Override
	public void drawTemporaryShape(Graphics2D g) {
		this.draw(g);
		this.drawTemporaryIcon(g);
	}
	
	@Override
	public void drawInBasketShape(Graphics2D g) {
		this.draw(g);
		this.drawInBasketIcon(g);
	}
	@Override
	protected void drawInBasketIcon(Graphics2D g) {
		Image image = new ImageIcon(GSConstants.ICON_PATH + "basketWithItem.png").getImage();
		Point2D iconPoint1 = this.getFirstAuxIconPoint(0, 0);
		int x = (int)iconPoint1.getX();
		int y = (int)iconPoint1.getY();
		int w = image.getWidth(null)/3;
		int h = image.getHeight(null)/3;
		g.drawImage(image, x, y, w, h, null);
	}
	@Override
	public void drawRWShape(Graphics2D g) {
		this.draw(g);
		this.drawRWicon(g);
	}

	private void drawRWicon(Graphics2D g) {
		Image image = new ImageIcon(GSConstants.ICON_PATH + "reasoning_web.png").getImage();
		Point2D iconPoint1 = this.getFirstAuxIconPoint(0, 0);
		int x = (int)iconPoint1.getX();
		int y = (int)iconPoint1.getY();
		int w = image.getWidth(null)/3;
		int h = image.getHeight(null)/3;
		g.drawImage(image, x, y, w, h, null);
	}
	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("view");
		element.setAttribute("type",URICreator.POLYGON);
		element.setAttribute("title",this.title);
		
		for(int i=0;i<this.lines.size();i++){
			element.appendChild(this.lines.get(i).createXMLElement(document));
		}
		return element;
	}

	public static PolygonView restore(Element element) {
		PolygonView view = new PolygonView();
		NodeList nodes = element.getChildNodes();
		String title = element.getAttribute("title");

		for(int i=0;i<nodes.getLength();i++){
			if(nodes.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)nodes.item(i);
				String tagname = elem.getNodeName();
				if(tagname.equals("view")){
					LineView line = LineView.restore(elem);
					view.addLineView(line);
				}
			}
		}
		return view;
	}
	@Override
	public Point getCenterPoint() {
		return new Point((int)this.getRectangle2D().getCenterX(),
							(int)this.getRectangle2D().getCenterY());
	}
	@Override
	public String getTypeStringForDisplay() {
		return "Polygon";
	}
	@Override
	public void drawLinkIcon(Graphics2D g, Image image) {
		if (this.lines.size()==0) {
			return;
		}
		Point2D iconPoint1 = this.getFirstAuxIconPoint(0, 0);
		int x = (int)iconPoint1.getX();
		int y = (int)iconPoint1.getY();
		int w = image.getWidth(null) / 3;
		int h = image.getHeight(null) / 3;
		g.drawImage(image, x, y, w, h, null);
	}
	@Override
	public void drawTemporaryIcon(Graphics2D g) {
		Image image = new ImageIcon(GSConstants.ICON_PATH + "Temporary.png").getImage();
		Point2D iconPoint1 = this.getFirstAuxIconPoint(0, 0);
		int x = (int)iconPoint1.getX();
		int y = (int)iconPoint1.getY();
		int w = image.getWidth(null)/3;
		int h = image.getHeight(null)/3;
		g.drawImage(image, x, y, w, h, null);
	}
	@Override
	public void drawSelectedIcon(Graphics2D g) {
		ImageIcon selected = new ImageIcon(GSConstants.ICON_PATH + "selected_mark.png");
		Image selectedImage = selected.getImage();
		Rectangle rect = this.getRectangle();
		Point2D selectedIconPoint = this.closestPoint(new Point2D.Double(rect.getX(),rect.getY()));
		int w = (int)(selectedImage.getWidth(null) / 2.5);
		int h = (int)(selectedImage.getHeight(null) / 2.5);
		int x = (int)(selectedIconPoint.getX()) - w;
		int y = (int)(selectedIconPoint.getY()) - h;
		g.drawImage(selectedImage, x, y, w, h, null);
		ImageIcon closeUp = new ImageIcon(GSConstants.ICON_PATH + "region_close_up.png");
		Image closeUpImage = closeUp.getImage();
		Rectangle closeUpImageRectangle = this.closeUpImageRectangle();
		int w2 = (int)closeUpImageRectangle.getWidth();
		int h2 = (int)closeUpImageRectangle.getHeight();
		int x2 = (int)closeUpImageRectangle.getX();
		int y2 = (int)closeUpImageRectangle.getY();
		if (closeUpImageRectangle.contains(selectedIconPoint)) {
			y2 = y2+(h2/2);
		}
		g.drawImage(closeUpImage, x2, y2, w2, h2, null);
	}

	@Override
	protected Rectangle closeUpImageRectangle() {
		Rectangle rect = this.getRectangle();
		Point2D rectPointSW = new Point2D.Double(rect.getX(), rect.getY() + rect.getHeight()); 
		ImageIcon closeUp = new ImageIcon(GSConstants.ICON_PATH + "region_close_up.png");
		Point2D pointSW = this.closestPoint(rectPointSW);
		Image closeUpImage = closeUp.getImage();
		int w = (int)(closeUpImage.getWidth(null) / 4.5);
		int h = (int)(closeUpImage.getHeight(null) / 4.5);
		int x = (int)(pointSW.getX()) - (int)(w * (1/2.0));
		int y = (int)(pointSW.getY()) - (int)(h * (1/2.0));
		return new Rectangle(x, y, w, h);
	}
	
	private Point2D closestPoint(Point2D from) {
		Point2D closestPoint = this.lines.get(0).getStartPoint();
		double distance = closestPoint.distance(from);
		for (int i = 0; i < this.lines.size(); i++) {
			Point2D point = this.lines.get(i).getStartPoint();
			if (point.distance(from) < distance) {
				closestPoint = point;
				distance = point.distance(from);
			}
		}
		return closestPoint; 
	}
	@Override
	public Point2D getFirstAuxIconPoint(int w, int h) {
		Rectangle rect = this.getRectangle();
		Point2D p = this.closestPoint(new Point2D.Double(rect.getX()+rect.getWidth(),rect.getY()));
		int x = (int)(p.getX() - w/3);
		int y = (int)(p.getY()) - h/2;
		return new Point2D.Double(x, y);
	}

}
