package smart_gs.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import smart_gs.GSConstants;
import smart_gs.transcription_tool.tesseract.HocrDocument;

public class OcrIDAT extends IDAT {
	
	private HocrDocument hocrDocument;
	private List<int[]> bboxList; 

	public OcrIDAT(Spread spread, String uri, String originalURI, String version) {
		super(spread, uri, originalURI, version);
		this.bboxList = new ArrayList<int[]>();
		parseBbox();
	}
	public OcrIDAT(String uri, String originalURI, String version) {
		super(uri, originalURI, version);
		this.bboxList = new ArrayList<int[]>();
		parseBbox();
	}
	public OcrIDAT(Spread spread) {
		super(spread);
		this.bboxList = new ArrayList<int[]>();		
		parseBbox();
	}

	@Override
	public int getType() {
		return GSConstants.OCRIDAT;
	}

	@Override
	public String getExtension() {
		return "ant";
	}

	@Override
	public String getTypeString() {
		return URICreator.OCR_IDAT;
	}
	public HocrDocument getHocrDocument() {
		return hocrDocument;
	}
	public void setHocrDocument(HocrDocument hocrDocument) {
		this.hocrDocument = hocrDocument;
	}
	
	private void parseBbox () {
		String regex = "bbox(?: | )(\\d+)(?: | )(\\d+)(?: | )(\\d+)(?: | )(\\d+)";
		Pattern p = Pattern.compile(regex);
		Matcher m = p.matcher(this.source);
		while (m.find()) {
			int x1 = Integer.parseInt(m.group(1));
			int y1 = Integer.parseInt(m.group(2));
			int x2 = Integer.parseInt(m.group(3));
			int y2 = Integer.parseInt(m.group(4));
			this.bboxList.add(new int[]{x1, y1, x2, y2});
		}
	}
	
}
