/* $Id: PageIndexTable.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.logical;

import java.util.Enumeration;
import java.util.Hashtable;


/**
 * 
 * @author kazuaki kobayashi
 * 
 * systemが自動で割り振ったページ番号と実際のmanuscript中の番号との
 * 対応付けを管理するためのテーブル
 * 
 * まだ使われていない。現在は、ファイル名をページ番号の代わりに使用
 */

public class PageIndexTable {
	
	private static PageIndexTable singleton = new PageIndexTable();
	
	private Hashtable<Integer,Integer> table;
	
	public static PageIndexTable getInstance(){
		return singleton;
	}
	
	private PageIndexTable(){
		this.table  = new Hashtable<Integer,Integer>();
	}
	
	public void setIndex(int systemIndex,int userIndex){
		table.put(systemIndex,userIndex);
	}
	public int getSystemIndex(int userIndex){
		if(table.containsValue(userIndex)){
			Enumeration keys = table.keys();
			while(keys.hasMoreElements()){
				int systemIndex = (Integer)keys.nextElement();
				if(table.get(systemIndex) == userIndex){
					return systemIndex;
				}
			}
		}
		return -1;
		
	}
	public int getUserIndex(int systemIndex){
		if(table.containsKey(systemIndex)){
			return table.get(systemIndex);
		}else{
			return -1;
		}
	}
	
}
