/* $Id: StandardTextDocument.java 1072 2016-02-27 04:27:27Z shayashi $ */
package smart_gs.logical;

import smart_gs.logical.visitor.Visitor;


public class StandardTextDocument extends SmartDocument{
	
	private boolean is_zombie = false;
	public StandardTextDocument(String uri, String originalURI) {
		super();
		this.setURIs(uri, originalURI);
	}
	public StandardTextDocument() {
		super();
		this.initializeURIs();
	}
	public StandardTextDocument(String source,String name, String uri,String originalURI, String version){
		super(source);
		this.name = name;
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}
	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getTypeString() {
		return URICreator.STANDARD_TEXT_DOCUMENT;
	}
	
//	2016.02.21 In this version, StandardTextDocument cannot be resuscitated.
	@Override
	public void makeItZombie() {
		this.is_zombie = true;
	}
	@Override
	public boolean isZombie() {
		return this.is_zombie;
	}
	@Override
	public void resuscitate() {
		// None
	}
}
