/* $Id: URISolver.java 885 2014-09-17 15:19:26Z shayashi $ */
package smart_gs.logical;

import javax.swing.JOptionPane;

import reasoning_web.logical.ExplanatoryNote;
import smart_gs.GSConstants;

import smart_gs.reasoning_web.logical.ExpNoteManager;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

/**
 * TODO
 * ちゃんとしたものを作る
 *
 */
public class URISolver {
	
	private static final String HEADER = URIObject.HEADER;
//	private static final String SEP1 = URIObject.SEP1;
//	private static final String SEP2 = URIObject.SEP2;
//	private static final String SEP3 = URIObject.SEP3;
//	private static final String SEP4 = URIObject.SEP4;
	
	public static Region getRegion(String uri){
		Region region = null;
		Spread spread = SpreadTree.getInstance().getSpreadByResourceURI(uri);
		if(spread == null){
			return null;
		}
		region = spread.getRegionByURI(uri);
		return region;
	}

	public static GSResource getUsersNote(String uri){
		GSResource usersNote = UsersNoteTree.getInstance().getUsersNoteByURI(uri);
		return usersNote;
	}

	public static GSResource getSpreadResource(String uri){
		Spread spread = SpreadTree.getInstance().getSpreadByResourceURI(uri);
		if (spread == null) return null;
		GSResource resource = spread.getResource(uri);
		if (resource == null) {
//			System.out.printf("The resource of %s does not exist.\n",uri);
			return null;
		}
		return resource;
	}
	public static GSResource getTextSegmentFromUsersNote(String uri) {
		UsersNote usersNote = (UsersNote)UsersNoteTree.getInstance().getUsersNoteByTextSegmentURI(uri);
		if (usersNote == null) return null;
		GSResource textSegment = usersNote.getTextSegmentByURI(uri);
		return textSegment;
	}
	
	// 20080909 hashimoto wrote
	public static Spread getSpread(String uri){
		Spread spread = SpreadTree.getInstance().getSpreadByURI(uri);
		return spread;
	}
	public static Spread getSpreadByDocumentURI(String documentURI) {
		Spread spread = SpreadTree.getInstance().getSpreadByResourceURI(documentURI);
		return spread;
	}

	// When it fails to find the resource, null is returned.
	public static GSResource getResource(String uri){
		GSResource resource = null;
		if(uri.contains(HEADER+"usersNote/")) {
				resource = getUsersNote(uri);
		}else if(uri.contains(HEADER+"explanatory/") && !URISolver.isATextSegmentFromExplanatoryNote(uri)) {
				resource = ExpNoteManager.getInstance().getResource(uri);
		}else if(uri.contains(HEADER+"package/")){
			//	TODO commented by shayashi 2011.02.17. What is this for?
			resource = null;
		}else if(uri.contains(HEADER+"document/") && !URISolver.isATextSegmentFromStandardTextDocument(uri)) {
				resource = ReasoningWebFrame.getInstance().getDesktopPanel().getResource(uri);
		}else if (isATextSegmentFromExplanatoryNote(uri)) {
			resource = getTextSegmentFromExplanatoryNote(uri);
		}else if (isATextSegmentFromUsersNote(uri)) {
			resource = getTextSegmentFromUsersNote(uri);
		} else {
			resource = getSpreadResource(uri);
		}
		return resource;
	}


	private static boolean isATextSegmentFromUsersNote(String uri) {
		return isATextSegmentURI(uri)
			&& URIObject.getTypeFrom(URIObject.getContainerURIFrom(uri))
				.equals(URIObject.USERS_NOTE);
	}

	private static GSResource getTextSegmentFromExplanatoryNote(String uri) {
		GSExplanatoryNote expNote = (GSExplanatoryNote)ExpNoteManager.getInstance()
			.getExplanatoryNoteByTextSegmentURI(uri);
		GSResource textSegment = expNote.getTextSegmentByURI(uri);
		return textSegment;
	}

	public static boolean isATextSegmentURI(String uri) {
		return uri.startsWith(URIObject.HEADER + URIObject.TEXT_SEGMENT);
	}

	private static boolean isATextSegmentFromStandardTextDocument(String uri) {
		return (uri.startsWith(HEADER+URIObject.TEXT_SEGMENT) && uri.contains(URIObject.STANDARD_TEXT_DOCUMENT))
		|| (uri.startsWith(HEADER+"document") && uri.substring(HEADER.length()).contains("//")); 
	}

	public static boolean isATextSegmentFromFirstIDAT(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.FIRST_IDAT) 
			&& !uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromSecondIDAT(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.SECOND_IDAT) 
			&& !uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromThirdIDAT(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.THIRD_IDAT) 
			&& !uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromExplanatoryNote(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);		
	}
	
	
	
	public static boolean isASmartDocumentURI(String uri) {
		return uri.startsWith(HEADER + URIObject.STANDARD_TEXT_DOCUMENT)
				|| uri.startsWith(HEADER + URIObject.FIRST_IDAT)
				|| uri.startsWith(HEADER + URIObject.SECOND_IDAT)
				|| uri.startsWith(HEADER + URIObject.THIRD_IDAT)
				|| uri.startsWith(HEADER + URIObject.EXPLANATORY_NOTE)
				|| uri.startsWith(HEADER + URIObject.USERS_NOTE);
	}

//	public static boolean isASmartDocumentOldVersionURI(String uri) {
//		return isAStandardTextDocumentOldVersionURI(uri)
//			|| isAUsersNoteOldVersionURI(uri)
//			|| isAnExplanatoryNoteOldVersionURI(uri)
//			|| isAnIDATOldVersionURI(uri);
//	}
//	public static boolean isAStandardTextDocumentOldVersionURI(String uri) {
//		return (uri.startsWith(HEADER + "document") && countSeparatorInURI(uri) == 4);
//	}
//	public static boolean isAUsersNoteOldVersionURI(String uri) {
//		return (uri.startsWith(HEADER + "presentation") && countSeparatorInURI(uri) == 5);
//	}
//	public static boolean isAnExplanatoryNoteOldVersionURI(String uri) {
//		return (uri.startsWith(HEADER + "explanatory") && countSeparatorInURI(uri) == 3);
//	}
//	public static boolean isAnIDATOldVersionURI(String uri) {
//		return isAFirstIDATOldVersionURI(uri)
//			|| isASecondIDATOldVersionURI(uri)
//			|| isAThirdIDATOldVersionURI(uri);
//	}
//	public static boolean isAFirstIDATOldVersionURI(String uri) {
//		return uri.endsWith("/transcription/");
//	}
//	public static boolean isASecondIDATOldVersionURI(String uri) {
//		return uri.endsWith("/annotation/");
//	}
//	public static boolean isAThirdIDATOldVersionURI(String uri) {
//		return uri.endsWith("/transcription/");
//	}
//	public static boolean isATextSegmentOldVersionURI(String uri) {
//		return isASmartDocumentOldVersionURI(chopIdFromOldVersionURI(uri));
//	}
	public static int countSeparatorInURI(String uri) {
		String sep = URIObject.SEP1;
		int count = 0;
		for (int i = 0; i < uri.length(); i++) {
			if (uri.substring(i,i+1).equals(sep)) {
				count++;
			}
		}
		return count;
	}
	public static String chopIdFromOldVersionURI(String uri) {
		for (int i = uri.length(); i >= 0; i-- ) {
			if (uri.substring(i-1,i).equals("/")) {
				return uri.substring(0, i-1);
			}
		}
		return null;
	}
//	public static boolean isATextSegmentOldVersionURIFromFirstIDAT(String uri) {
//		return isAFirstIDATOldVersionURI(chopIdFromOldVersionURI(uri));
//	}
//	public static boolean isATextSegmentOldVersionURIFromSecondIDAT(String uri) {
//		return isASecondIDATOldVersionURI(chopIdFromOldVersionURI(uri));
//	}
//	public static boolean isATextSegmentOldVersionURIFromThirdIDAT(String uri) {
//		return isAThirdIDATOldVersionURI(chopIdFromOldVersionURI(uri));
//	}

}
