/* $Id: MemoPadRegion.java 185 2011-05-27 03:51:24Z minao $ */
package smart_gs.logical.region;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Rectangle2D.Double;


import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public class MemoPadRegion extends Region{
	private boolean deleteArrowPointMode;
	
	public MemoPadRegion(Spread spread, Rectangle2D rectangle, String uri, String originalURI, String version){
		super(spread, new MemoPadView(rectangle, MemoPadView.defaultMemoPadText),uri,originalURI, version);
	}


	public MemoPadRegion(Spread spread, Rectangle2D rectangle) {
		super(spread, new MemoPadView(rectangle, MemoPadView.defaultMemoPadText));
	}


	public MemoPadRegion getRegion(Region region) {
		return (MemoPadRegion) region;
	}
	
	public String getMemoPadText() {
		return ((MemoPadView)this.view).getMemoPadText();
	}
	
	public void setMemoPadText(String text) {
		((MemoPadView)this.view).setMemoPadText(text);
	}
	
	public void setDeleteArrowPointMode(boolean b) {
		((MemoPadView)this.getView()).setDeleteArrowPointMode(b);
	}
}
