package smart_gs.menu;

import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.logical.Preference;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.action.DeleteDscFileAction;
import smart_gs.swingui.toolbar.action.DeleteSegfoFileAction;
import smart_gs.swingui.toolbar.action.DeleteXmlLineSegmentFileAction;
import smart_gs.swingui.toolbar.action.DscCompileAction;
import smart_gs.swingui.toolbar.action.ImportDscFileAction;
import smart_gs.swingui.toolbar.action.LineSegDscInformationAction;
import smart_gs.swingui.toolbar.action.ReadSegfoFileAction;
import smart_gs.swingui.toolbar.action.ReadXMLLineSegmentFileAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAndDscCompileAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsInSegfoFormatAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsInXMLFormatAction;



public class LineSegFileMenu extends JMenu{
	
	private LineSegEditor editor;
	
	public LineSegFileMenu(LineSegEditor editor, String type) {
		super("File");
		
		this.editor = editor;
		
		if (type.equals("xml")) {

			JMenuItem saveLSeg0 = new JMenuItem("Save (XML)");
			saveLSeg0.addActionListener(new SaveLineSegmentsInXMLFormatAction(this.editor,true));
			saveLSeg0.setToolTipText("Save Line Segments in Default File in XML Format");
			saveLSeg0.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
			this.add(saveLSeg0);

			JMenuItem saveLSeg = new JMenuItem("Save as... (XML)");
			saveLSeg.addActionListener(new SaveLineSegmentsInXMLFormatAction(this.editor,false));
			saveLSeg.setToolTipText("Save Line Segments in a Specified File in XML Format");
			this.add(saveLSeg);

			JMenuItem deleteXmlLSeg = new JMenuItem("Delete XML Line Seg File");
			deleteXmlLSeg.addActionListener(new DeleteXmlLineSegmentFileAction(this.editor));
			deleteXmlLSeg.setToolTipText("Delete XML Line Segments File");
			this.add(deleteXmlLSeg);
			
			JMenuItem readLSeg = new JMenuItem("Read XML Line Seg File");
			readLSeg.addActionListener(new ReadXMLLineSegmentFileAction(this.editor));
			readLSeg.setToolTipText("Read XML format Line Segment File");
			this.add(readLSeg);
			this.addSeparator();

			JMenuItem createDSC = new JMenuItem("Make DSC File");
			createDSC.addActionListener(new DscCompileAction(this.editor));
			createDSC.setToolTipText("Make DSC File");
			this.add(createDSC);

			JMenuItem createLineSegAndDSC = new JMenuItem("Save & Make DSC");
			createLineSegAndDSC.addActionListener(new SaveLineSegmentsAndDscCompileAction(this.editor));
			createLineSegAndDSC.setToolTipText("Save Line Seg & Make DSC File");
			this.add(createLineSegAndDSC);

			JMenuItem deleteDSC = new JMenuItem("Delete DSC File");
			deleteDSC.addActionListener(new DeleteDscFileAction(this.editor));
			deleteDSC.setToolTipText("Delete DSC File");
			this.add(deleteDSC);

			JMenuItem importDSC = new JMenuItem("Import DSC File");
			importDSC.addActionListener(new ImportDscFileAction(this.editor));
			importDSC.setToolTipText("Import DSC File");
			this.add(importDSC);

			this.addSeparator();

			JMenuItem saveLSegSegfo = new JMenuItem("Save in Segfo File");
			saveLSegSegfo.addActionListener(new SaveLineSegmentsInSegfoFormatAction(this.editor,false));
			saveLSegSegfo.setToolTipText("Save as Segfo File");
			this.add(saveLSegSegfo);

			JMenuItem readLSegSegfo = new JMenuItem("Read Segfo File");
			readLSegSegfo.addActionListener(new ReadSegfoFileAction(this.editor));
			readLSegSegfo.setToolTipText("Read Segfo File");
			this.add(readLSegSegfo);


			JMenuItem deleteSegfo = new JMenuItem("Delete Segfo File");
			deleteSegfo.addActionListener(new DeleteSegfoFileAction(this.editor));
			deleteSegfo.setToolTipText("Delete Segfo File");
			this.add(deleteSegfo);


			this.addSeparator();

			JMenuItem infoLSeg = new JMenuItem("Info");
			infoLSeg.addActionListener(new LineSegDscInformationAction(this.editor));
			infoLSeg.setToolTipText("Line Seg & DSC Information");
			this.add(infoLSeg);} 
		else {
			JMenuItem saveLSegSegfo0 = new JMenuItem("Save (SEGFO)");
			saveLSegSegfo0.addActionListener(new SaveLineSegmentsInSegfoFormatAction(this.editor,true));
			saveLSegSegfo0.setToolTipText("Save as Segfo File");
			saveLSegSegfo0.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
			this.add(saveLSegSegfo0);
			
			JMenuItem saveLSegSegfo = new JMenuItem("Save as ... (SEGFO)");
			saveLSegSegfo.addActionListener(new SaveLineSegmentsInSegfoFormatAction(this.editor,false));
			saveLSegSegfo.setToolTipText("Save as Segfo File");
			this.add(saveLSegSegfo);

			JMenuItem readLSegSegfo = new JMenuItem("Read Segfo File");
			readLSegSegfo.addActionListener(new ReadSegfoFileAction(this.editor));
			readLSegSegfo.setToolTipText("Read Segfo File");
			this.add(readLSegSegfo);


			JMenuItem deleteSegfo = new JMenuItem("Delete Segfo File");
			deleteSegfo.addActionListener(new DeleteSegfoFileAction(this.editor));
			deleteSegfo.setToolTipText("Delete Segfo File");
			this.add(deleteSegfo);

			this.addSeparator();

			JMenuItem saveLSeg = new JMenuItem("Save in XML File");
			saveLSeg.addActionListener(new SaveLineSegmentsInXMLFormatAction(this.editor,false));
			saveLSeg.setToolTipText("Save Line Segments in a Specified File in XML Format");
			this.add(saveLSeg);

			JMenuItem deleteXmlLSeg = new JMenuItem("Delete XML Line Seg File");
			deleteXmlLSeg.addActionListener(new DeleteXmlLineSegmentFileAction(this.editor));
			deleteXmlLSeg.setToolTipText("Delete XML Line Segments File");
			this.add(deleteXmlLSeg);

			JMenuItem readLSeg = new JMenuItem("Read XML Line Seg File");
			readLSeg.addActionListener(new ReadXMLLineSegmentFileAction(this.editor));
			readLSeg.setToolTipText("Read XML format Line Segment File");
			this.add(readLSeg);
			this.addSeparator();

			JMenuItem createDSC = new JMenuItem("Make DSC File");
			createDSC.addActionListener(new DscCompileAction(this.editor));
			createDSC.setToolTipText("Make DSC File");
			this.add(createDSC);

			JMenuItem createLineSegAndDSC = new JMenuItem("Save & Make DSC");
			createLineSegAndDSC.addActionListener(new SaveLineSegmentsAndDscCompileAction(this.editor));
			createLineSegAndDSC.setToolTipText("Save Line Seg & Make DSC File");
			this.add(createLineSegAndDSC);

			JMenuItem deleteDSC = new JMenuItem("Delete DSC File");
			deleteDSC.addActionListener(new DeleteDscFileAction(this.editor));
			deleteDSC.setToolTipText("Delete DSC File");
			this.add(deleteDSC);

			JMenuItem importDSC = new JMenuItem("Import DSC File");
			importDSC.addActionListener(new ImportDscFileAction(this.editor));
			importDSC.setToolTipText("Import DSC File");
			this.add(importDSC);
	
			this.addSeparator();

			JMenuItem infoLSeg = new JMenuItem("Info");
			infoLSeg.addActionListener(new LineSegDscInformationAction(this.editor));
			infoLSeg.setToolTipText("Line Seg & DSC Information");
			this.add(infoLSeg);
		}
	}
}
