package smart_gs.menu.action;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


import smart_gs.swingui.WorkspaceWindow;

public class DefaultFileTypeSwitchChangeListener implements ChangeListener {

	private JRadioButton gsxSwitch;
	private JRadioButton hcpSwitch;
	private JButton gsxReference;
	private JComboBox hcpReference;

	public DefaultFileTypeSwitchChangeListener(JRadioButton gsxButton,
			JRadioButton hcpButton, JButton gsxReference,
			JComboBox hcpReference) {
		this.gsxSwitch = gsxButton;
		this.hcpSwitch = hcpButton;
		this.gsxReference = gsxReference;
		this.hcpReference = hcpReference;

	}

	@Override
	public void stateChanged(ChangeEvent e) {
		if (gsxSwitch.isSelected()) {
			this.gsxReference.setEnabled(true);
			this.hcpReference.setEnabled(false);
		} else if (hcpSwitch.isSelected()) {
			this.gsxReference.setEnabled(false);
			this.hcpReference.setEnabled(true);
		}
		WorkspaceWindow.getInstance().repaint();
	}

}
