/* $Id: SetDirectoryPathAction.java 495 2012-03-23 01:54:16Z minao $ */
package smart_gs.menu.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFileChooser;

import smart_gs.menu.DirectorySettingWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
/**
 * 外部にあるファイルを使う場合、そのpathを指定するためのアクション
 * @author Administrator
 *
 */
//2007/11/20 kazuhiro kobayashi
public abstract class SetDirectoryPathAction implements ActionListener {
	protected String dialogTitle;
	protected JFileChooser chooser;
	public SetDirectoryPathAction(){
		//oldPathをデフォルトとするファイルチューザーを作る
		chooser = new JFileChooser(getOldPath());
//		chooser.setDialogTitle(this.dialogTitle);
		chooser.setApproveButtonText("Set");
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		
	}
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		DirectorySettingWindow.getInstance().setAlwaysOnTop(false);
		int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
		if(input == JFileChooser.CANCEL_OPTION){
			DirectorySettingWindow.getInstance().setAlwaysOnTop(true);
			return;
		}
		DirectorySettingWindow.getInstance().setAlwaysOnTop(true);
		//選択したpathで設定する
		validateNewPath(getNewPath());
	}
	protected abstract String getOldPath();
	protected String getNewPath(){
		return CanonicalPathString.get(chooser.getSelectedFile());
	}
	protected abstract void validateNewPath(String newPath);
	

}
