package smart_gs.network;
import java.awt.BorderLayout;
import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import smart_gs.swingui.WorkspaceWindow;

import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectListComboBoxPanel extends JPanel{

	private JComboBox comboBox;
	private List<HCPProject> projects;
	
	public ProjectListComboBoxPanel(List<HCPProject> projects, String location) {
		this.projects = projects;
		DefaultComboBoxModel model = new DefaultComboBoxModel();
		for (int i = 0; i < projects.size(); i++) {
			model.addElement(projects.get(i).name);
		}
 		this.comboBox = new JComboBox(model);
 		WorkspaceWindow window = WorkspaceWindow.getInstance();
 		HCPProject currentProject = window.getCurrentProject();
 		if (currentProject != null) {
 			int index = 0;
 			for (int i = 0; i < this.projects.size(); i++) {
 				if (projects.get(i).name.equals(currentProject.name)) {
 					index = i;
 					break;
 				}
 			}
 			this.comboBox.setSelectedIndex(index); 
 		}
		this.add(comboBox,BorderLayout.CENTER);
	}

	public HCPProject getSelectedProject() {
		int index = this.comboBox.getSelectedIndex();
		if (index >= 0) {
			return this.projects.get(index);
		} else {
			return null; 
		}
	}

	public int getSelectedIndex() {
		return this.comboBox.getSelectedIndex();
	}
}