/* $Id: GSEditorSourcePopupMenu.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.smleditor.swingui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

import com.hexidec.ekit.GSHTMLRuntimeEditor;

@SuppressWarnings("serial")
public class GSEditorSourcePopupMenu extends JPopupMenu{
	protected JTextArea jtpSource;
	public GSEditorSourcePopupMenu(final JTextArea jtpSource) {
		this.jtpSource = jtpSource;
		GSHTMLRuntimeEditor gsHTMLRuntimeEditor = new GSHTMLRuntimeEditor(jtpSource);
		JMenuItem sourceEditor = new JMenuItem("Edit by External Editor");
		sourceEditor.addActionListener(gsHTMLRuntimeEditor);
		this.add(sourceEditor);
		
		JMenuItem copy = new JMenuItem("Copy");
		copy.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				jtpSource.copy();
			}
		});
		this.add(copy);

		JMenuItem cut = new JMenuItem("Cut");
		cut.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				jtpSource.cut();
			}
		});
		this.add(cut);

		JMenuItem paste = new JMenuItem("Paste");
		paste.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				jtpSource.paste();
			}
		});
		this.add(paste);
	}
	
	
	
}
