/* $Id: ButtonFrame.java 602 2012-10-11 18:54:42Z minao $ */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

@SuppressWarnings("serial")
public abstract class ButtonFrame extends JFrame implements ActionListener{
	
	protected JButton okButton;
	protected JButton cancelButton;
	private JPanel buttonPanel;
	private boolean isCanceled = true;
	
	public ButtonFrame(Frame parent,String title){
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		Image icon = new ImageIcon("./icons/SGS_icon.gif").getImage();
		this.setIconImage(icon);
		this.getContentPane().setLayout(new BorderLayout());
		this.buttonPanel = new JPanel();
		this.okButton = new JButton("OK");
		this.okButton.addActionListener(this);

		this.cancelButton = new JButton("Cancel");
		this.cancelButton.addActionListener(this);
		this.buttonPanel.add(this.okButton);
		this.buttonPanel.add(this.cancelButton);
		
		//2007/11/27 kazuhiro kobayashi
		this.setTitle(title);
		
		this.getContentPane().add(this.buttonPanel,BorderLayout.SOUTH);
	}
	public boolean isCanceled(){
		return this.isCanceled;
	}
	public ButtonFrame(String title) {
		this(new JFrame(),title);
	}
	//2007/10/30 kazuhiro kobayashi
	public ButtonFrame(String title, String name){
		this(new JFrame(), title);
		this.setTitle(name);
	}
	public JPanel getButtonPanel(){
		return this.buttonPanel;
	}

	public abstract void ok();
	public abstract void cancel();
	
	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(this.okButton)){
			this.isCanceled = false;
			this.ok();
		}else if(e.getSource().equals(this.cancelButton)){
			this.isCanceled = true;
			this.cancel();
		}
		
	}
}
