package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;


import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyleContext;

import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.action.LineSegEditorMoveAndResizeFrameButtonsActionListener;



@SuppressWarnings("serial")
public class LineSegEditorMoveAndResizeFrame extends JFrame implements ChangeListener {
	LineSegEditor parent;
	JRadioButton normalspeed;
	JRadioButton octuplespeed;
	JRadioButton hexadectuplespeed;

	
	
	public LineSegEditorMoveAndResizeFrame(LineSegEditor editor){
		super("Move & Resize Line Segments");
		SetIcon.setIcon(this);
		this.parent = editor;
		
		// resize buttons panel
		JPanel reseizebuttonpanel = new JPanel();
		reseizebuttonpanel.setLayout(new GridLayout(1,2));
		JButton change1 = new JButton("-");
		change1.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,40));
		change1.addActionListener(new LineSegEditorMoveAndResizeFrameButtonsActionListener(this.parent,0,0));
		JButton change2 = new JButton("+");
		change2.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,40));
		change2.addActionListener(new LineSegEditorMoveAndResizeFrameButtonsActionListener(this.parent,0,1));
		reseizebuttonpanel.add(change1);
		reseizebuttonpanel.add(change2);
		
		
		// Step option button panel
		JPanel stepoptionpanel = new JPanel(new GridLayout(1,3));
//		stepoptionpanel.setBorder(new TitledBorder("Step speed"));
		this.normalspeed = new JRadioButton("x 1");
		this.octuplespeed = new JRadioButton("x 8");
		this.hexadectuplespeed = new JRadioButton("x 16");
		this.normalspeed.addChangeListener(this);
		this.octuplespeed.addChangeListener(this);
		this.hexadectuplespeed.addChangeListener(this);
		this.normalspeed.setSelected(true);
		ButtonGroup group = new ButtonGroup();
		group.add(this.normalspeed);
		group.add(this.octuplespeed);
		group.add(this.hexadectuplespeed);
		stepoptionpanel.add(this.normalspeed);
		stepoptionpanel.add(this.octuplespeed);
		stepoptionpanel.add(this.hexadectuplespeed);
		
		// reseize buttons with step options
		JPanel reseizebuttonpanelwithstepoptionpanel = new JPanel();
		reseizebuttonpanelwithstepoptionpanel.setLayout(new BorderLayout());
		reseizebuttonpanelwithstepoptionpanel.add(reseizebuttonpanel,BorderLayout.CENTER);
		reseizebuttonpanelwithstepoptionpanel.add(stepoptionpanel,BorderLayout.SOUTH);
		
		// Move buttons
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		JButton up = new JButton("↑");
		up.addActionListener(new LineSegEditorMoveAndResizeFrameButtonsActionListener(this.parent,1,0));
		JButton down = new JButton("↓");
		down.addActionListener(new LineSegEditorMoveAndResizeFrameButtonsActionListener(this.parent,1,1));
		JButton right = new JButton("→");
		right.addActionListener(new LineSegEditorMoveAndResizeFrameButtonsActionListener(this.parent,1,2));
		JButton left = new JButton("←");
		left.addActionListener(new LineSegEditorMoveAndResizeFrameButtonsActionListener(this.parent,1,3));
		
		// Layout all
		panel.add(up,BorderLayout.NORTH);
		panel.add(down,BorderLayout.SOUTH);
		panel.add(right,BorderLayout.EAST);
		panel.add(left,BorderLayout.WEST);
		panel.add(reseizebuttonpanelwithstepoptionpanel,BorderLayout.CENTER);
		
		this.add(panel);
		this.setSize(300,200);
		
	}


	@Override
	public void stateChanged(ChangeEvent arg0) {
		int mag = 1;
		if (this.normalspeed.isSelected()) mag = 1;
		if (this.octuplespeed.isSelected()) mag = 2;
		if (this.hexadectuplespeed.isSelected()) mag = 8;
		this.parent.setResizeMagnificaiton(mag);
		
	}
}
