/* $Id: ImageToolBar.java 1049 2016-01-03 14:25:56Z shayashi $ */
package smart_gs.swingui.toolbar;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

import smart_gs.GSConstants;

import smart_gs.drawing_tool.drawing_mode.CloseUpRectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.logical.Preference;
import smart_gs.logical.Sheet;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.ImageToolBarComponent.IMAGETOOLBARCOMPONENT_TYPE;

@SuppressWarnings("serial")
public class ImageToolBar extends JToolBar implements ActionListener{

	private Select select;
	private Deleter deleter;
	private JButton rectangle;
	private JButton bookmark;
	private JButton memopad;
	private JButton marker;
	private JButton polygon;
	private JButton tmprectangle;
	private JButton tmpbookmark;
	private JButton tmpmarker;
	private JButton tmppolygon;
	private JButton redo;
	private JButton undo;

	public static int modeNone = 0;
	public static int modeRectangle = 1;
	public static int modeMarker = 2;
	public static int modePolygon = 3;
	public static int modeMemoPad = 4;
	public static int modeBookmark = 5;
	public static int modeCloseUpRectangle = 6;
	public static int modeDelete = 7;
	public static int modeTmpRectangle = 8;
	public static int modeTmpMarker = 9;
	public static int modeTmpPolygon = 10;
	public static int modeTmpBookmark = 11;
	public static int modeTmpLines = 12;

	private ZoomIn zoomIn;
	private ZoomOut zoomOut;
	private FullSize fullSize;
	private FitWidth fitWidth;
	private FitHeight fitHeight;

	//	private JButton hideRegion;
	private ShowRegion showRegion;
	private String[] showregionarray = { "All Regions", "Protected Regions", "No Region" };
	public static int showAll = 0;
	public static int showProtected = 1;
	public static int showNo = 2;

//	private JButton changeSheet;

	private AbstractGSWindow parent;
private CloseUp closeUp;

	public ImageToolBar(AbstractGSWindow parent){
		this.parent = parent;
		
		this.undo = new Select(new ImageIcon(GSConstants.ICON_PATH+"undo.gif"));
		this.undo.addActionListener(this.parent.undo);
		this.undo.setToolTipText("Undo");
		this.add(this.undo);
		
		this.redo = new Select(new ImageIcon(GSConstants.ICON_PATH+"redo.gif"));
		this.redo.addActionListener(this.parent.redo);
		this.redo.setToolTipText("redo");
		this.add(this.redo);
		
		this.select = new Select(new ImageIcon(GSConstants.ICON_PATH+"select.gif"));
		this.select.addActionListener(this.parent.select);
		this.select.setToolTipText("Select");
		this.add(this.select);

		this.deleter = new Deleter(new ImageIcon(GSConstants.ICON_PATH+"delete.png"));
		this.deleter.addActionListener(this.parent.delete);
		this.deleter.setToolTipText("Delete");
		this.add(this.deleter);
		
		this.addSeparator();
			
		this.rectangle = new JButton(new ImageIcon(GSConstants.ICON_PATH+"rectangle.png"));
		this.rectangle.addActionListener(this.parent.rectangle);
		this.rectangle.setToolTipText("Rectangle");
		this.add(this.rectangle);
		
		this.bookmark = new JButton(new ImageIcon(GSConstants.ICON_PATH+"bookmark_small.png"));
		this.bookmark.addActionListener(this.parent.bookmark);
		this.bookmark.setToolTipText("Bookmark");
		this.add(this.bookmark);

		this.marker = new JButton(new ImageIcon(GSConstants.ICON_PATH+"marker_small.png"));
		this.marker.addActionListener(this.parent.marker);
		this.marker.setToolTipText("Rectangle");
		this.add(this.marker);

		this.polygon = new JButton(new ImageIcon(GSConstants.ICON_PATH+"polygon.png"));
		this.polygon.addActionListener(this.parent.polygon);
		this.add(this.polygon);

		this.memopad = new JButton(new ImageIcon(GSConstants.ICON_PATH+"memopad_small.png"));
		this.memopad.addActionListener(this.parent.memopad);
		this.add(this.memopad);
		
		if (Preference.getInstance().isTempRegionOn()) {
			this.tmprectangle = new JButton(new ImageIcon(GSConstants.ICON_PATH+"rectangle_tmp.png"));
			this.tmprectangle.addActionListener(this.parent.tmprectangle);
			this.tmprectangle.setToolTipText("tmp Rectangle");
			this.add(this.tmprectangle);
			
			this.tmpbookmark = new JButton(new ImageIcon(GSConstants.ICON_PATH+"bookmark_small_tmp.png"));
			this.tmpbookmark.addActionListener(this.parent.tmpbookmark);
			this.tmpbookmark.setToolTipText("tmp Bookmark");
			this.add(this.tmpbookmark);

			this.tmpmarker = new JButton(new ImageIcon(GSConstants.ICON_PATH+"marker_small_tmp.png"));
			this.tmpmarker.addActionListener(this.parent.tmpmarker);
			this.tmpmarker.setToolTipText("Rectangle");
			this.add(this.tmpmarker);

			this.tmppolygon = new JButton(new ImageIcon(GSConstants.ICON_PATH+"polygon_tmp.png"));
			this.tmppolygon.addActionListener(this.parent.tmppolygon);
			this.add(this.tmppolygon);
		}

		this.addSeparator();
		
		this.closeUp = new CloseUp(new ImageIcon(GSConstants.ICON_PATH+"region_close_up_small.png"));
		this.closeUp.addActionListener(this.parent.closeup);
		this.closeUp.setToolTipText("Close Up");
		this.add(this.closeUp);
		


		// Refactor this part. ModeList should be a non-graphical being.
		// Currently, it is a JCombBox.
//		this.modelist = new ModeList(modelistarray);
//		this.modelist.addActionListener(this);
//		this.modelist.setToolTipText("Select Drawing Mode");
//		this.add(modelist);


		this.zoomIn = new ZoomIn(new ImageIcon(GSConstants.ICON_PATH+"zoom_in.gif"));
		this.zoomIn.addActionListener(this.parent.zoomIn);
		this.zoomIn.setToolTipText("Zoom in");
//		this.zoomIn.setEnabled(false);
		this.add(this.zoomIn);

		this.zoomOut = new ZoomOut(new ImageIcon(GSConstants.ICON_PATH+"zoom_out.gif"));
		this.zoomOut.addActionListener(this.parent.zoomOut);
		this.zoomOut.setToolTipText("Zoom out");
//		this.zoomOut.setEnabled(false);
		this.add(this.zoomOut);

		this.fullSize = new FullSize(new ImageIcon(GSConstants.ICON_PATH + "100percent.png"));
		this.fullSize.addActionListener(this.parent.fullSize);
		this.fullSize.setToolTipText("Full Size");
//		this.fullSize.setEnabled(false);
		this.add(this.fullSize);

		this.fitWidth = new FitWidth(new ImageIcon(GSConstants.ICON_PATH + "fitwidth.png"));
		this.fitWidth.addActionListener(this.parent.fitWidth);
		this.fitWidth.setToolTipText("Fit Width");
//		this.fitWidth.setEnabled(false);
		this.add(this.fitWidth);

		this.fitHeight = new FitHeight(new ImageIcon(GSConstants.ICON_PATH + "fitheight.png"));
		this.fitHeight.addActionListener(this.parent.fitHeight);
		this.fitHeight.setToolTipText("Fit Height");
//		this.fitHeight.setEnabled(false);
		this.add(this.fitHeight);

		showRegion = new ShowRegion(showregionarray);
		showRegion.addActionListener(this);
		showRegion.setToolTipText("Select the type of Regions to show");

	}

	public void actionPerformed(ActionEvent e) {
		 if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.SHOW_REGION)){
			String showRegionMode = (String) ((JComboBox) e.getSource()).getSelectedItem();
			if(showRegionMode == showregionarray[showAll]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_ALL_REGIONS);
			} else if(showRegionMode == showregionarray[showProtected]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_PROTECTED_REGIONS);
			} else if(showRegionMode == showregionarray[showNo]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_NO_REGIONS);
			}
			parent.repaint();
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.CLOSE_UP)){
			DefaultState.getInstance().setMode(CloseUpRectangleMode.getInstance());
			parent.setMode(CloseUpRectangleMode.getInstance());
//			this.setModeListItem(this.modelistarray[ImageToolBar.modeCloseUpRectangle]);
			parent.repaint();
		}
	}

	public void enableIcons() {
		this.zoomIn.setEnabled(true);
		this.zoomOut.setEnabled(true);
		this.fullSize.setEnabled(true);
		this.fitWidth.setEnabled(true);
		this.fitHeight.setEnabled(true);
	}

	public void setModeListItem(String string) {
//		modelist.setSelectedItem(string);
	}

	public void setShowRegionItem(String string) {
		showRegion.setSelectedItem(string);
	}

	private class Select extends JButton implements ImageToolBarComponent {

		Select(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.SELECT;
		}
	}

	private class Deleter extends JButton implements ImageToolBarComponent {

		Deleter(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.DELETER;
		}
	}
	
	private class CloseUp extends JButton implements ImageToolBarComponent {
		CloseUp(ImageIcon icon) {
			super(icon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.CLOSE_UP;
		}
	}

	private class ShowRegion extends JComboBox implements ImageToolBarComponent {

		ShowRegion(String[] showregionarray) {
			super(showregionarray);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.SHOW_REGION;
		}
	}

	private class ZoomIn extends JButton implements ImageToolBarComponent {

		ZoomIn(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ZOOM_IN;
		}
	}

	private class ZoomOut extends JButton implements ImageToolBarComponent {

		ZoomOut(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ZOOM_OUT;
		}
	}

	private class FullSize extends JButton implements ImageToolBarComponent {

		FullSize(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.FULL_SIZE;
		}
	}

	private class FitWidth extends JButton implements ImageToolBarComponent {

		FitWidth(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.FIT_WIDTH;
		}
	}

	private class FitHeight extends JButton implements ImageToolBarComponent {

		FitHeight(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.FIT_HEIGHT;
		}
	}

	public void setShowRegionItem(int mode) {
		this.setShowRegionItem(this.showregionarray[mode]);
	}

}
