package smart_gs.swingui.toolbar;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;


import smart_gs.GSConstants;
import smart_gs.swingui.AbstractGSWindow;

@SuppressWarnings("serial")
public class RbRwToolBar extends JToolBar {

	private AbstractGSWindow parent;
	private JButton resourceBasket;
	private JButton reasoningWeb;

	public RbRwToolBar(AbstractGSWindow parent) {
		this.parent = parent;
		
		this.resourceBasket = new Basket(new ImageIcon(GSConstants.ICON_PATH+"basket.png"));
		this.resourceBasket.addActionListener(this.parent.resourceBasket);
		this.resourceBasket.setToolTipText("Open Resource Basket Window");
		this.add(resourceBasket);
		

		this.reasoningWeb = new JButton(new ImageIcon(GSConstants.ICON_PATH+"reasoningweb.png"));
		this.reasoningWeb.addActionListener(this.parent.reasoningWeb);
		this.reasoningWeb.setToolTipText("Open Resioning Web");
		this.add(this.reasoningWeb);

	}
	

	private class Basket extends JButton implements ImageToolBarComponent {

		Basket(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.BASKET;
		}
	}
}
