/* $Id: ShowLinesActionListener.java 885 2014-09-17 15:19:26Z shayashi $ */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class ShowLinesActionListener implements ActionListener {

	private AbstractGSWindow parent;

	public ShowLinesActionListener(AbstractGSWindow parent) {
		this.parent = parent;
	}

	public void actionPerformed(ActionEvent e) {
		if (this.parent == null) return;
		SpreadCanvas canvas = this.parent.getSpreadCanvas();
		if (canvas == null) return;
		ImageLabel.Show mode = canvas.imageLabel.getLineSegShowingMode();
		canvas.imageLabel.stepLineSegShowingMode(mode);
		
//		Debugprint.message("current show-line mode: " + this.parent.getSpreadCanvas().imageLabel.getLineSegShowingMode());
		if(parent instanceof WorkspaceWindow) {
			WorkspaceWindow.getInstance().repaint();
		} else if (parent instanceof GSEditor) {
			parent.repaint();
		}
	}

}
