/* $Id: ReplaceResultPanel.java 609 2012-11-29 10:22:01Z ohura $ */
package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Dimension;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;
import javax.swing.text.Highlighter;
import javax.swing.text.DefaultHighlighter.DefaultHighlightPainter;

@SuppressWarnings("serial")
public class ReplaceResultPanel extends JPanel{
	private ReplaceResultPanel(TextToShow textToShow, String queryReplaceText, String documentURI, int index){
		super();
		this.setPreferredSize(new Dimension(200, 50));
		this.setLayout(new BorderLayout());
		this.setBorder(new TitledBorder(documentURI));
		this.setSize(400,50);
		JTextField field = new JTextField();
		field.setHorizontalAlignment(SwingConstants.LEFT);
		field.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		field.setText(textToShow.getText().substring(0, textToShow.getIndex()) + queryReplaceText
					+ textToShow.getText().substring(textToShow.getIndex()+textToShow.getLength()));
		field.setBackground( Color.white );
		field.setOpaque( true );
		field.setEditable(false);
		field.setEnabled(false);
		field.setDisabledTextColor(Color.BLACK);
		this.add(field,BorderLayout.WEST);
		setHighlight(textToShow, queryReplaceText, field);
	}
	public static ReplaceResultPanel getInstance(TextToShow textToShow, String queryReplaceText, String documentURI, int index) {
		return new ReplaceResultPanel(textToShow, queryReplaceText, documentURI,index); 
	}
	
	private void setHighlight(TextToShow textToShow, String queryReplaceText, JTextField field){
		Highlighter hilite = field.getHighlighter();
		DefaultHighlightPainter hilightPainter = new DefaultHighlightPainter(Color.yellow);
		try{
			hilite.addHighlight(textToShow.getIndex(), textToShow.getIndex()+queryReplaceText.length(), hilightPainter);	
		}catch(Exception e){
			System.out.println(e);
		}
	}
}
