package smart_gs.util;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

import smart_gs.GSConstants;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.LineSegment;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import sml_editor.logical.LineDirection;

public class SegfoToLineConverter {
	
		private Spread spread;
		String file_name;
		GSLog log = GSLog.getInstance();
		
		public SegfoToLineConverter(Spread spread){
			this.spread = spread;
			this.file_name = spread.getFileName();
		}
		
		public Pair<LineDirection,List<LineSegment>> getLines(File file){
			return getLines(file,this.file_name);
		}
		
		public Pair<LineDirection,List<LineSegment>> getLines(File file, String file_name){
			if (! file.exists()) {
				GSLog.getInstance().warnWithWindow(String.format("File%n  " + file + "%ndoes not exist"));
				return null;
			}
			String firstLineString;
			String secondLineString;
			LineDirection lineDirection = LineDirection.UNDEFINED;
			List<LineSegment> lines = new ArrayList<LineSegment>();
			
			StringBuffer bodyBufStr = new StringBuffer();
			try{
	            FileReader fr = new FileReader(file);
	            BufferedReader br = new BufferedReader(fr);
	            String tmp_str;
	            
	            if ((firstLineString = br.readLine()) == null) {
	                log.error("Someting wrong to read the first line of the file: " + file);
		            br.close();
	            }
	            
	            if ((secondLineString = br.readLine()) == null) {
	            	log.error("Someting wrong to read the second line of the file: " + file);
		            br.close();
	            } else {
	            	secondLineString = secondLineString.trim();
	            }
	           
	            
	            if ( ! secondLineString.equalsIgnoreCase("Horizontal") && ! secondLineString.equalsIgnoreCase("Vertical")) {
	            	System.out.printf("Warning: the second line of the file %s is %s.%n  It should be Vertical or Horizontal.%n", file, secondLineString);
					log.warn("  The Line Direction is set to the defualt UNDEFINED");
	            } else {
	            	lineDirection = secondLineString.equalsIgnoreCase("Horizontal")?LineDirection.HORIZONTAL:LineDirection.VERTICAL;
	            }
	            
	            while((tmp_str = br.readLine()) != null){
	                bodyBufStr.append(tmp_str);
	                bodyBufStr.append('\t');
	            }
	            br.close();
	        }
	        catch(IOException e){
	            e.printStackTrace();
	            log.error("Something wrong to read the file: " + file);
	            return null;
	        }
	        
	        int start = firstLineString.indexOf(file_name);
	        for (int i=0;i<start;i++) {
	        	if (!Character.isWhitespace(firstLineString.indexOf(i))) {
	        		log.warn(String.format("Warning: first line \"%s\" does not match the spread file name: \"%s\"",firstLineString,file_name));
	        	}
	        }
	        for (int i=start+file_name.length();i<firstLineString.length();i++) {
	        	if (!Character.isWhitespace(firstLineString.indexOf(i))) {
	        		log.warn(String.format("Warning: first line \"%s\" does not match the spread file name: \"%s\"",firstLineString,file_name));
	        	}
	        }
			
	        String file_contents = bodyBufStr.toString();
	        String[] tokenArray = file_contents.split("[\\x20\\u0009\\u000D]+");
	        List<Integer> intList = new ArrayList<Integer>();
	        for (int i = 0;i<tokenArray.length;i++){
	        	if (tokenArray[i].isEmpty()) i++;
	        	try {
	        		int tmpInt = Integer.parseInt(tokenArray[i]);
	        		intList.add(tmpInt);
	        	} catch (NumberFormatException e) {
	        		log.error( String.format("%d-th element %d of  \"%s\" cannot be parsed as an integer",i,file_name,tokenArray[i]));
	        		return null;
	        	}
	        }
	        
	        if (intList.get(intList.size()-1)!=-99999) {
	        	log.error(String.format("The last token should be -99999, but is %d in  \"%s\" ",intList.get(intList.size()),file_name));
	        }
	        intList.remove(intList.size()-1);
	        List<Point2D> tmpPointsList = new ArrayList<Point2D>();
	        int size = intList.size();
	        int index = 0;
	        for (int i=0;i<size;i++) {
	        	int tmpIntX = intList.get(i);
	        	if (tmpIntX==-1){
	        		if (tmpPointsList.isEmpty()) {
	        			log.error(String.format("The line ends with %d-th element -1 is empty",i));
	        			return null;
	        		}
	        		lines.add(new LineSegment(spread,tmpPointsList,index));
	        		index++;
	        		tmpPointsList = new ArrayList<Point2D>();
	        		continue;
	        	}
	        	if (tmpIntX<0) {
	        		log.error(String.format("%d-th integer %d (x-axis) in the body is negative ",i,tmpIntX));
	        	}
	        	i++;
	        	if (i>=size) {
	        		log.error(String.format("The data did not end with -1"));
	        		return null;
	        	}
	        	int tmpIntY = intList.get(i);
	        	if (tmpIntY<0) {
	        		log.error(String.format("%d-th integer (y-axis) %d in the body is negative ",i,tmpIntX));
	        	}
	        	tmpPointsList.add((Point2D.Double)(new Point2D.Double((double)tmpIntX,(double)tmpIntY)));
	        }
	 
			return new Pair<LineDirection,List<LineSegment>>(lineDirection,lines);
		}
		
		public  Pair<LineDirection,List<LineSegmentForEdit>> getLinesForEdit(File file){
			return getLinesForEdit(file,this.file_name);
		}

		public Pair<LineDirection,List<LineSegmentForEdit>> getLinesForEdit(File file, String file_name){
			if (! file.exists()) {
				GSLog.getInstance().warnWithWindow(String.format("File%n" + file + "%ndoes not exist"));
				return null;
			}
			String firstLineString;
			String secondLineString;
			LineDirection lineDirection = LineDirection.UNDEFINED;
			List<LineSegmentForEdit> lines = new ArrayList<LineSegmentForEdit>();
			
			StringBuffer bodyBufStr = new StringBuffer();
			FileReader fr = null;
			BufferedReader br = null;
			try{
	            fr = new FileReader(file);
	            br = new BufferedReader(fr);
	            String tmp_str;
	            
	            if ((firstLineString = br.readLine()) == null) {
	                log.error("Someting wrong to read the first line of the file: " + file);
	            }
	            
	            if ((secondLineString = br.readLine()) == null) {
	            	log.error("Someting wrong to read the second line of the file: " + file);
	            }
	            
	            while((tmp_str = br.readLine()) != null){
	                bodyBufStr.append(tmp_str);
	                bodyBufStr.append('\t');
	            }
	        }
	        catch(IOException e){
	            e.printStackTrace();
	            log.error("Something wrong to read the file: " + file);
	            return null;
	        }
			finally {
            	try {
					br.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
	            try {
					fr.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
	        
	        int start = firstLineString.indexOf(file_name);
	        for (int i=0;i<start;i++) {
	        	if (!Character.isWhitespace(firstLineString.indexOf(i))) {
	        		log.warn(String.format("Warning: first line \"%s\" does not match the spread file name: \"%s\"",firstLineString,file_name));
	        	}
	        }
	        for (int i=start+file_name.length();i<firstLineString.length();i++) {
	        	if (!Character.isWhitespace(firstLineString.indexOf(i))) {
	        		log.warn(String.format("Warning: first line \"%s\" does not match the spread file name: \"%s\"",firstLineString,file_name));
	        	}
	        }
	        
            if ( ! secondLineString.equalsIgnoreCase("Horizontal") && ! secondLineString.equalsIgnoreCase("Vertical")) {
            	log.warn(String.format("Warning: the second line of the file %s is %s.%n  It should be Vertical or Horizontal.%n  The Line Direction is set to the defualt UNDEFINED",
            			file, secondLineString));
            } else {
            	lineDirection = secondLineString.equalsIgnoreCase("Horizontal")?LineDirection.HORIZONTAL:LineDirection.VERTICAL;
            }
			
	        String file_contents = bodyBufStr.toString();
	        String[] tokenArray = file_contents.split("[\\x20\\u0009\\u000D]+");
	        List<Integer> intList = new ArrayList<Integer>();
	        for (int i = 0;i<tokenArray.length;i++){
	        	if (tokenArray[i].isEmpty()) i++;
	        	try {
	        		int tmpInt = Integer.parseInt(tokenArray[i]);
	        		intList.add(tmpInt);
	        	} catch (NumberFormatException e) {
	        		log.error(String.format("%d-th element %d cannot be parsed as an integer",i,tokenArray[i]));
	        		return null;
	        	}
	        }
	        
	        if (intList.get(intList.size()-1)!=-99999) {
	        	log.error(String.format("The last token should be -99999, but is %d",intList.get(intList.size())));
	        }
	        intList.remove(intList.size()-1);
	        List<Point2D> tmpPointsList = new ArrayList<Point2D>();
	        int size = intList.size();
	        int index =0;
	        for (int i=0;i<size;i++) {
	        	int tmpIntX = intList.get(i);
	        	if (tmpIntX==-1){
	        		if (tmpPointsList.isEmpty()) {
	        			log.error(String.format("The line ends with %d-th element -1 is empty",i));
	        			return null;
	        		}
	        		lines.add(new LineSegmentForEdit(tmpPointsList,lineDirection,index));
	        		index++;
	        		tmpPointsList = new ArrayList<Point2D>();
	        		continue;
	        	}
	        	if (tmpIntX<0) {
	        		log.error(String.format("%d-th integer %d (x-axis) in the body is negative ",i,tmpIntX));
	        	}
	        	i++;
	        	if (i>=size) {
	        		log.error(String.format("The data did not end with -1"));
	        		return null;
	        	}
	        	int tmpIntY = intList.get(i);
	        	if (tmpIntY<0) {
	        		log.error(String.format("%d-th integer (y-axis) %d in the body is negative ",i,tmpIntX));
	        	}
	        	tmpPointsList.add((Point2D.Double)(new Point2D.Double((double)tmpIntX,(double)tmpIntY)));
	        }
	 
			return new Pair<LineDirection,List<LineSegmentForEdit>>(lineDirection,lines);
		}
	}
