/* $Id: SmlDocument.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 作成日： 2004/10/12
 *
 * TODO この生成されたファイルのテンプレートを変更するには次を参照。
 * ウィンドウ ＞ 設定 ＞ Java ＞ コード・スタイル ＞ コード・テンプレート
 */
package sml_editor.node;

import java.util.StringTokenizer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;


/**
 * @author kawamura
 *
 * TODO この生成された型コメントのテンプレートを変更するには次を参照。
 * ウィンドウ ＞ 設定 ＞ Java ＞ コード・スタイル ＞ コード・テンプレート
 */
public class SmlDocument extends SmlChildNode {
	private Document fDocument;
	private SmlElement fRoot;
	
	/**
	 * @param document
	 */
	public SmlDocument(Document document) {
		fDocument = document;
		fRoot = new SmlElement(document.getDocumentElement());
	}

	protected int calculateLength() {
		return fRoot.calculateLength();
	}

	public Node getNode() {
		return fDocument;
	}

	public SmlElement createElement(String tagName) {
		Element elem = fDocument.createElement(tagName);
		return new SmlElement(elem);
	}
	
	public SmlText createTextNode(String data) {
		Text text = fDocument.createTextNode(data);
		return new SmlText(text);
	}
	
	public SmlBR createBRNode() {
		Element elem = fDocument.createElement("br");
		return new SmlBR(elem);
	}
	
	public SmlElement getDocumentElement() {
		return fRoot;
	}

	public short getNodeType() {
		return SmlNode.DOCUMENT_NODE;
	}

	/**
	 * パスがあらわすSmlNodeを取得する。
	 * 例えばpathが "/2/4/3" ならば、
	 * rootの2番目の子の4番目の子の3番目の子であるノードを返す。
	 * @param path
	 * @return
	 */
	public SmlNode getNodeByPath(String path) {
		try {
			SmlNode node = fRoot;
			StringTokenizer tokens = new StringTokenizer(path, "/");
			while(tokens.hasMoreTokens()) {
				int index = Integer.parseInt(tokens.nextToken());
				node = ((SmlElement)node).getChild(index);
			}
			return node;
		} catch (NumberFormatException e) {
			// TODO 自動生成した catch ブロック
			e.printStackTrace();
		} catch (NullPointerException e) {
			// TODO 自動生成した catch ブロック
			e.printStackTrace();
		}
		return null;
	}
}
