/* $Id: WebDavSyncProgressBar.java 125 2011-03-09 09:49:51Z ohura $ */
package webdav;

import javax.swing.*;

import webdav.WebDavSyncData.DownLoadSyncInfo;
import webdav.WebDavSyncData.SyncInfo;

import java.awt.*;
import java.awt.event.*;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;


public class WebDavSyncProgressBar extends JDialog {

    private JPanel panel;
    private JLabel label;
    private JProgressBar pbar;
    private JDialog myJDialog;
    private AtomicInteger counter = new AtomicInteger();  //  @jve:decl-index=0:
    private boolean end = true;
    private int max;
    protected WebDavSyncData webDavSyncData;
    protected ArrayList downloadInfoList = new ArrayList();  //  @jve:decl-index=0:
    protected boolean cancel = false;
    public WebDavSyncProgressBar(JFrame jframe,WebDavSyncData webDavSyncData,String title,final int min,final int max) {
    	super(jframe,title,true);
		initialize();
		this.max = max;
        setLayout( new FlowLayout() );
//        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
//        setDefaultCloseOperation( JDialog.DO_NOTHING_ON_CLOSE );

        Container container = getContentPane();
        container.setLayout( new FlowLayout() );

        pbar = new JProgressBar(min,min,max);
        pbar.setStringPainted( true );
        pbar.setIndeterminate( false );

//        panel = new MyPanel();
        label = new JLabel( "" );

        GridLayout gridLayout = new GridLayout();
		gridLayout.setRows(2);
		JPanel jContentPane = new JPanel();
		jContentPane.setLayout(gridLayout);
		jContentPane.add(pbar);
		jContentPane.add(label);
        this.setContentPane(jContentPane);

        Runnable task = new Runnable() {
        	public void run() {
        		while ( counter.intValue() <= max ) {
        			pbar.setValue( counter.intValue() );
                    try {
                    	Thread.sleep(10);
                    } catch ( Exception e ) {
                    }
                    if(cancel){
                    	break;
                    }
        		}
                label.setText( "completed job" );
                try {
                	Thread.sleep(100);
                } catch (InterruptedException e) {
			}
            myJDialog.setVisible(false);
            if(counter.intValue() != 0){
            	String cancelMsg = "";
            	if(cancel){
            		cancelMsg = "It was canceled.\r\n";
            	}
            	JOptionPane.showMessageDialog(new JFrame(), cancelMsg + "Please reboot SMART-GS.");
            }
        	}
        };
        new Thread( task ).start();
        myJDialog = this;
        this.webDavSyncData = webDavSyncData;

    }
    public void countup(){
    	counter.incrementAndGet();
    }
    public void setLabel(String str){
    	label.setText( str );
    }
    public void setDownloadInfoList(ArrayList downloadInfoList){
    	this.downloadInfoList = downloadInfoList;
    }
    public void sync(){
    	Runnable task = new Runnable() {
        	public void run() {
        		for(int n=0;n<downloadInfoList.size();n++){
        			WebDavSyncDownloadInfo webDavSyncDownloadInfo = (WebDavSyncDownloadInfo)downloadInfoList.get(n);
        			String path = webDavSyncDownloadInfo.getPath();
        			ArrayList downloadList = webDavSyncDownloadInfo.getDownloadList();
            		for(int i=0;i<downloadList.size();i++){
            			DownLoadSyncInfo downLoadSyncInfo = (DownLoadSyncInfo)downloadList.get(i);
            			SyncInfo syncInfo = downLoadSyncInfo.getSyncInfo();
            			String downloadpath = syncInfo.getPropFindInfo().getPath();
        				String downloadfile = syncInfo.getPropFindInfo().getDisplayname();
            			if(!downLoadSyncInfo.getSyncInfo().getPropFindInfo().isDirectory()){
            				setLabel(downloadpath + downloadfile);
            			}else{
            				setLabel(downloadpath);
            			}
              			webDavSyncData.download(downLoadSyncInfo.getKey(),path,downLoadSyncInfo.getSyncInfo());
              			if(cancel){
              				end = false;
              				return;
              			}
            			countup();
              			try {
            				Thread.sleep(100);
            			} catch (InterruptedException e) {
            				// TODO 自動生成された catch ブロック
            				e.printStackTrace();
            			}
            		}
            		countup();
        		}
        		end = false;
        	}
        };
        new Thread( task ).start();
    }
    public void join(){
    	while(end){
    		 try {
             	Thread.sleep(100);
             } catch (InterruptedException e) {}
    	}
    }
    public void end(){
    	counter = new AtomicInteger(max);
    }
    /**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setSize(new Dimension(361, 91));
			
	}
	protected void processWindowEvent(WindowEvent e) {
	    if (e.getID() == WindowEvent.WINDOW_CLOSING ) {
	    	cancel=true;
	    	join();
	        this.setVisible(false);
	    }
	}
}  //  @jve:decl-index=0:visual-constraint="10,10"

