/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.jersey.ext.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import jp.ac.nii.hcp.shared.jersey.ext.annotation.ProducesFor;
import jp.ac.nii.hcp.shared.model.OAuthToken;
import jp.ac.nii.hcp.shared.model.TokenUsage;

@Provider
public class OAuthTokenBodyWriter
implements MessageBodyWriter<OAuthToken> {
    public long getSize(OAuthToken token, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (OAuthToken.class.isAssignableFrom(type) && mediaType.isCompatible(MediaType.TEXT_PLAIN_TYPE)) {
            return this.getUsage(annotations) != null;
        }
        return false;
    }

    public void writeTo(OAuthToken token, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        TokenUsage usage = this.getUsage(annotations);
        if (usage == null) {
            throw new WebApplicationException();
        }
        StringBuffer buf = new StringBuffer();
        switch (usage) {
            case REQUEST_REQUEST_TOKEN: {
                buf.append("oauth_token=").append(token.token).append("&oauth_token_secret=").append(token.secret);
                break;
            }
            case AUTH_REQUEST_TOKEN: {
                buf.append("oauth_token=").append(token.token).append("&oauth_verifier=").append(token.verifier);
                break;
            }
            case REQUEST_ACCESS_TOKEN: {
                buf.append("oauth_token=").append(token.token).append("&oauth_token_secret=").append(token.secret);
            }
        }
        OutputStreamWriter writer = new OutputStreamWriter(entityStream);
        writer.write(buf.toString());
        writer.flush();
    }

    private TokenUsage getUsage(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (ann instanceof ProducesFor) {
                String usageKey = ((ProducesFor)ann).value();
                try {
                    TokenUsage usage = TokenUsage.valueOf(usageKey);
                    return usage;
                }
                catch (Exception e) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }
}

