/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.module;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseProcessor {
    private static ThreadLocal<Map<Class<? extends BaseProcessor>, BaseProcessor>> cache = null;
    protected Connection db = null;
    protected Log log = null;

    static {
        cache = new ThreadLocal<Map<Class<? extends BaseProcessor>, BaseProcessor>>(){

            @Override
            protected Map<Class<? extends BaseProcessor>, BaseProcessor> initialValue() {
                return new HashMap<Class<? extends BaseProcessor>, BaseProcessor>();
            }
        };
    }

    public BaseProcessor(Connection db) {
        this.db = db;
        this.log = LogFactory.getLog(this.getClass());
    }

    public void setConnection(Connection db) {
        this.db = db;
    }

    public static <T extends BaseProcessor> T getProcessor(Class<T> processor, Connection db, Object ... args) {
        if (!cache.get().containsKey(processor) || args.length > 0) {
            try {
                Constructor<?>[] constructors = processor.getConstructors();
                int i = 0;
                while (i < constructors.length) {
                    Constructor<?> constructor = constructors[i];
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (Connection.class.isAssignableFrom(paramTypes[0]) && paramTypes.length == args.length + 1) {
                        boolean match = true;
                        int j = 0;
                        while (j < args.length) {
                            if (args[j] != null && !paramTypes[j + 1].isInstance(args[j])) {
                                match = false;
                                break;
                            }
                            ++j;
                        }
                        if (match) {
                            Object[] constructArgs = new Object[paramTypes.length];
                            constructArgs[0] = db;
                            int j2 = 0;
                            while (j2 < args.length) {
                                constructArgs[j2 + 1] = args[j2];
                                ++j2;
                            }
                            cache.get().put(processor, (BaseProcessor)constructor.newInstance(constructArgs));
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                return null;
            }
        } else {
            cache.get().get(processor).setConnection(db);
        }
        return (T)((BaseProcessor)processor.cast(cache.get().get(processor)));
    }

    private void setParameter(PreparedStatement stmt, Object[] params) throws SQLException {
        int index = 1;
        int i = 0;
        while (i < params.length) {
            stmt.setObject(index, params[i]);
            ++index;
            ++i;
        }
    }

    private void setParameter(PreparedStatement stmt, Iterable<? extends Object> params) throws SQLException {
        int index = 1;
        for (Object object : params) {
            stmt.setObject(index++, object);
        }
    }

    protected PreparedStatement prepareStatement(String sql, Object ... params) throws SQLException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("SQL: %s", sql));
        }
        if (this.log.isDebugEnabled()) {
            StringBuffer paramString = new StringBuffer();
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    paramString.append(", ");
                }
                paramString.append(params[i] != null ? params[i].toString() : "null");
                ++i;
            }
            this.log.debug((Object)String.format("Holder: %s", paramString.toString()));
        }
        PreparedStatement stmt = this.db.prepareStatement(sql);
        if (params.length > 0) {
            this.setParameter(stmt, params);
        }
        return stmt;
    }

    protected PreparedStatement prepareStatement(String sql, Iterable<? extends Object> params) throws SQLException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("SQL: %s", sql));
        }
        if (this.log.isDebugEnabled()) {
            StringBuffer paramString = new StringBuffer();
            int index = 0;
            for (Object object : params) {
                if (index > 0) {
                    paramString.append(", ");
                }
                paramString.append(object != null ? object.toString() : "null");
                ++index;
            }
            this.log.debug((Object)String.format("Holder: %s", paramString.toString()));
        }
        PreparedStatement stmt = this.db.prepareStatement(sql);
        if (params != null) {
            this.setParameter(stmt, params);
        }
        return stmt;
    }

    protected ResultSet doQuery(String sql, Object ... params) throws SQLException {
        return this.prepareStatement(sql, params).executeQuery();
    }

    protected int doCount(String sql, Object ... params) throws SQLException {
        ResultSet rs = this.prepareStatement(sql, params).executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    protected int doUpdate(String sql, Object ... params) throws SQLException {
        return this.prepareStatement(sql, params).executeUpdate();
    }

    protected ResultSet doQuery(String sql, Iterable<? extends Object> params) throws SQLException {
        return this.prepareStatement(sql, params).executeQuery();
    }

    protected int doCount(String sql, Iterable<? extends Object> params) throws SQLException {
        ResultSet rs = this.prepareStatement(sql, params).executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    protected int doUpdate(String sql, Iterable<? extends Object> params) throws SQLException {
        return this.prepareStatement(sql, params).executeUpdate();
    }

    protected ResultSet doQuery(PreparedStatement stmt, Object ... params) throws SQLException {
        if (params.length > 0) {
            this.setParameter(stmt, params);
        }
        return stmt.executeQuery();
    }

    protected int doUpdate(PreparedStatement stmt, Object ... params) throws SQLException {
        if (params.length > 0) {
            this.setParameter(stmt, params);
        }
        return stmt.executeUpdate();
    }

    protected ResultSet doQuery(PreparedStatement stmt, Iterable<? extends Object> params) throws SQLException {
        if (params != null) {
            this.setParameter(stmt, params);
        }
        return stmt.executeQuery();
    }

    protected int doUpdate(PreparedStatement stmt, Iterable<? extends Object> params) throws SQLException {
        if (params != null) {
            this.setParameter(stmt, params);
        }
        return stmt.executeUpdate();
    }

    protected String getHolderString(int length, String[] unquoted) {
        StringBuffer buf = new StringBuffer();
        this.appendHolderString(length, unquoted, buf);
        return buf.toString();
    }

    protected void appendHolderString(int length, String[] unquoted, StringBuffer buf) {
        int i = 0;
        while (i < length) {
            if (i > 0) {
                buf.append(", ");
            }
            if (unquoted != null && unquoted.length > i && unquoted[i] != null) {
                buf.append(unquoted[i]);
            } else {
                buf.append("?");
            }
            ++i;
        }
    }

    protected String getValuesHolder(int columns, int length, String[] unquoted) {
        StringBuffer buf = new StringBuffer();
        this.appendValuesHolder(columns, length, unquoted, buf);
        return buf.toString();
    }

    protected void appendValuesHolder(int columns, int length, String[] unquoted, StringBuffer buf) {
        int i = 0;
        while (i < length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("(");
            this.appendHolderString(columns, unquoted, buf);
            buf.append(")");
            ++i;
        }
    }

    public int getLastInsertId() throws SQLException {
        ResultSet rs = this.db.createStatement().executeQuery("SELECT LAST_INSERT_ID()");
        rs.next();
        return rs.getInt(1);
    }

    public int getFoundRows() throws SQLException {
        ResultSet rs = this.db.createStatement().executeQuery("SELECT FOUND_ROWS()");
        rs.next();
        return rs.getInt(1);
    }
}

