/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.module;

import jp.ac.nii.hcp.shared.module.MutualMap;

public class ListAttributes<S> {
    public static MutualMap<Order, String> ORDER = null;
    private int page = 1;
    private S sort = null;
    private Order order = Order.ASC;
    private Integer limit = 10;

    static {
        ORDER = new MutualMap<Order, String>(Order.class, String.class, {Order.ASC, "ASC", "asc"}, {Order.DESC, "DESC", "desc"}, {Order.RANDOM, "RAND()", "random"}, {Order.UNDEF, "ASC", "undef"});
    }

    public ListAttributes(Integer page, S sort, Order order, Integer limit) {
        this.page = page != null ? page : 1;
        this.sort = sort;
        this.order = order != null ? order : Order.ASC;
        this.limit = limit > 0 ? limit : 10;
    }

    public ListAttributes(Integer page, S sort, Order order, Integer limit, ListAttributes<S> defaultAttributes) {
        this.page = page != null ? page : defaultAttributes.page;
        this.sort = sort != null ? sort : defaultAttributes.sort;
        this.order = order != null ? order : defaultAttributes.order;
        this.limit = limit != null && limit > 0 ? limit : defaultAttributes.limit;
    }

    public int getPage() {
        return this.page;
    }

    public S getSort() {
        return this.sort;
    }

    public Order getOrder() {
        return this.order;
    }

    public String getOrderLabel() {
        return ORDER.getLabel(this.order);
    }

    public int getLimit() {
        return this.limit != null ? this.limit : -1;
    }

    public int getOffset() {
        return this.limit != null ? (this.page - 1) * this.limit : -1;
    }

    public boolean forSort() {
        return this.sort != null;
    }

    public boolean forRange() {
        return this.limit != null;
    }

    public static enum Order {
        ASC,
        DESC,
        RANDOM,
        UNDEF;

    }
}

