/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.resource;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.oauth.server.OAuthServerRequest;
import com.sun.jersey.oauth.signature.OAuthRequest;
import java.sql.SQLException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import jp.ac.nii.hcp.shared.jersey.ext.annotation.ProducesFor;
import jp.ac.nii.hcp.shared.model.HCPMixedWrapper;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.model.OAuthToken;
import jp.ac.nii.hcp.shared.service.ServiceSession;
import jp.ac.nii.hcp.shared.service.TokenAPI;

@Path(value="/")
public class TokenResource {
    public static final String REQUEST_PATH = "/request";

    @POST
    @Path(value="/request")
    @Produces(value={"text/plain"})
    @ProducesFor(value="REQUEST_REQUEST_TOKEN")
    public OAuthToken requestToken(@Context HttpContext context) throws SQLException {
        OAuthServerRequest oauthRequest = new OAuthServerRequest(context.getRequest());
        TokenAPI service = ServiceSession.openService(TokenAPI.class);
        OAuthToken token = service.newRequestToken((OAuthRequest)oauthRequest);
        if (token != null) {
            return token;
        }
        throw new WebApplicationException(400);
    }

    @POST
    @Path(value="/login")
    @Produces(value={"text/plain"})
    @ProducesFor(value="AUTH_REQUEST_TOKEN")
    public OAuthToken authenticateToken(@QueryParam(value="token") String token, @QueryParam(value="email") String email, @QueryParam(value="password") String password) throws SQLException {
        TokenAPI service = ServiceSession.openService(TokenAPI.class);
        OAuthToken requestToken = service.authorizeToken(token, email, password);
        if (requestToken != null) {
            return requestToken;
        }
        throw new WebApplicationException(401);
    }

    @POST
    @Path(value="/access")
    @Produces(value={"text/plain"})
    @ProducesFor(value="REQUEST_ACCESS_TOKEN")
    public OAuthToken accessToken(@Context HttpContext context) throws SQLException {
        OAuthServerRequest oauthRequest = new OAuthServerRequest(context.getRequest());
        TokenAPI service = ServiceSession.openService(TokenAPI.class);
        OAuthToken token = service.newAccessToken((OAuthRequest)oauthRequest);
        if (token != null) {
            return token;
        }
        throw new WebApplicationException(401);
    }

    @DELETE
    @Path(value="/logout")
    public void logout(@Context HttpContext context) throws SQLException {
        OAuthServerRequest oauthRequest = new OAuthServerRequest(context.getRequest());
        TokenAPI service = ServiceSession.openService(TokenAPI.class);
        OAuthToken token = service.verifyAccessRequest((OAuthRequest)oauthRequest);
        if (token == null) {
            throw new WebApplicationException(401);
        }
        service.disableToken(token.token);
    }

    @GET
    @Path(value="/check")
    @Produces(value={"application/xml"})
    public HCPMixedWrapper checkToken(@Context HttpContext context) throws SQLException {
        OAuthServerRequest oauthRequest = new OAuthServerRequest(context.getRequest());
        TokenAPI service = ServiceSession.openService(TokenAPI.class);
        OAuthToken token = service.verifyAccessRequest((OAuthRequest)oauthRequest);
        if (token != null) {
            return new HCPMixedWrapper().add(token.user).add(token.group);
        }
        throw new WebApplicationException(401);
    }

    @POST
    @Path(value="/group/{group_id}")
    @Produces(value={"application/xml"})
    public HCPUserGroup changeGroup(@Context HttpContext context, @PathParam(value="group_id") String groupId) throws SQLException {
        OAuthServerRequest oauthRequest = new OAuthServerRequest(context.getRequest());
        TokenAPI service = ServiceSession.openService(TokenAPI.class);
        HCPUserGroup group = service.changeGroup((OAuthRequest)oauthRequest, groupId);
        if (group != null) {
            return group;
        }
        throw new WebApplicationException(401);
    }
}

