/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jp.ac.nii.hcp.shared.environment.ConnectionFactory;
import jp.ac.nii.hcp.shared.service.AutoClosingSession;
import jp.ac.nii.hcp.shared.service.Connect;
import jp.ac.nii.hcp.shared.service.ConnectionService;
import jp.ac.nii.hcp.shared.service.DefaultImpl;
import jp.ac.nii.hcp.shared.service.ServiceAPI;
import jp.ac.nii.hcp.shared.service.ServiceValidationException;
import jp.ac.nii.hcp.shared.service.Transactional;
import jp.ac.nii.hcp.shared.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceSession {
    private static AtomicInteger counter = new AtomicInteger();
    private static Map<Class<? extends ServiceAPI>, Class<? extends ConnectionService>> serviceBundle = new HashMap<Class<? extends ServiceAPI>, Class<? extends ConnectionService>>();
    private int id = ServiceSession.nextId();
    private Connection db;
    private boolean connecting = false;
    private boolean transactional = false;
    private boolean status = true;
    private boolean closing = false;
    private Map<Object, List<Object>> records;
    private Log log = LogFactory.getLog(this.getClass());

    ServiceSession() {
        this.records = new HashMap<Object, List<Object>>();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("[ServiceSession #%d] New session is created.", this.id));
        }
    }

    private static int nextId() {
        counter.compareAndSet(Integer.MAX_VALUE, 0);
        return counter.incrementAndGet();
    }

    public static ServiceSession open() {
        return new ServiceSession();
    }

    private static Class<? extends ConnectionService> searchDefaultImpl(Class<? extends ServiceAPI> type) {
        Class<?>[] innerClasses;
        Class<? extends ConnectionService> implType;
        if (serviceBundle.containsKey(type)) {
            return serviceBundle.get(type);
        }
        if (type.isAnnotationPresent(DefaultImpl.class) && (implType = type.getAnnotation(DefaultImpl.class).value()) != null) {
            serviceBundle.put(type, implType);
            return implType;
        }
        Class<?>[] classArray = innerClasses = type.getClasses();
        int n = innerClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inner = classArray[n2];
            if (ConnectionService.class.isAssignableFrom(inner) && type.isAssignableFrom(inner)) {
                Class<ConnectionService> implType2 = inner.asSubclass(ConnectionService.class);
                serviceBundle.put(type, implType2);
                return implType2;
            }
            ++n2;
        }
        return null;
    }

    public static <S extends ServiceAPI> S openService(Class<S> type) {
        Class<? extends ConnectionService> implType = ServiceSession.searchDefaultImpl(type);
        if (implType == null) {
            return null;
        }
        return ServiceSession.openService(type, implType);
    }

    public static <S extends ServiceAPI, T extends ConnectionService> S openService(Class<S> type, Class<T> implType) {
        AutoClosingSession session = new AutoClosingSession();
        return session.createService(type, implType);
    }

    public void close() {
        try {
            if (this.db != null) {
                this.db.close();
                this.db = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("[ServiceSession #%d] Database connection is released.", this.id));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void connect() throws SQLException {
        this.db = ConnectionFactory.getConnection();
    }

    public boolean isConnected() {
        try {
            return this.db != null && !this.db.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    Connection getConnection() throws SQLException {
        if (this.connecting && this.db == null) {
            this.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("[ServiceSession #%d] Connected to database " + (this.transactional ? "with" : "without") + " transaction", this.id));
            }
        }
        this.db.setAutoCommit(!this.transactional);
        return this.db;
    }

    public void commit() throws SQLException {
        if (this.isConnected() && this.transactional) {
            this.db.commit();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("[ServiceSession #%d] Transaction is committed.", this.id));
            }
        }
    }

    public void rollback() throws SQLException {
        if (this.isConnected() && this.transactional) {
            this.db.rollback();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("[ServiceSession #%d] Transaction is rollbacked.", this.id));
            }
        }
    }

    public void mark(boolean status) {
        this.status = status;
    }

    public void yield(Object key, Object value) {
        if (!this.records.containsKey(key)) {
            this.records.put(key, new ArrayList());
        }
        this.records.get(key).add(value);
    }

    public List<Object> inquire(Object key) {
        return this.records.get(key);
    }

    protected void finishup() {
        if (this.closing) {
            this.close();
        }
    }

    protected void toClose(boolean closing) {
        this.closing = closing;
    }

    public <S extends ServiceAPI> S createService(Class<S> type) {
        Class<? extends ConnectionService> implType = ServiceSession.searchDefaultImpl(type);
        if (implType == null) {
            this.log.fatal((Object)String.format("Default implementation service for %s is not found.", type.getName()));
            return null;
        }
        return this.createService(type, implType);
    }

    public <S extends ServiceAPI, T extends ConnectionService> S createService(Class<S> type, Class<T> implType) {
        if (!type.isInterface()) {
            this.log.fatal((Object)String.format("[ServiceSession #%d] Failed to create service because %s is not an interface.", this.id, type.getName()));
            return null;
        }
        if (!type.isAssignableFrom(implType)) {
            this.log.fatal((Object)String.format("[ServiceSession #%d] Failed to create service because %s is not compatible to %s.", this.id, implType.getName(), type.getName()));
            return null;
        }
        try {
            ConnectionService impl = (ConnectionService)implType.newInstance();
            impl.setSession(this);
            return (S)((ServiceAPI)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)this.createInvocator(type, impl)));
        }
        catch (Exception e) {
            this.log.fatal((Object)String.format("[ServiceSession #%d] Failed to create service because %s can't be instantiated.", this.id, implType.getName()), (Throwable)e);
            return null;
        }
    }

    protected <S extends ServiceAPI, T extends ConnectionService> ServiceInvocator createInvocator(Class<S> type, T impl) {
        return new ServiceInvocator(type, impl);
    }

    protected static class ServiceInvocator
    implements InvocationHandler {
        private Class<? extends ServiceAPI> type;
        private ConnectionService service;
        private Map<Method, EnumSet<ConnectionFlg>> methods;
        private Log log;

        ServiceInvocator(Class<? extends ServiceAPI> type, ConnectionService service) {
            Method[] methods;
            this.type = type;
            this.service = service;
            this.methods = new HashMap<Method, EnumSet<ConnectionFlg>>();
            this.log = LogFactory.getLog(this.getClass());
            boolean toConnect = true;
            boolean withTransaction = false;
            Connect connect = type.getAnnotation(Connect.class);
            Transactional transactional = type.getAnnotation(Transactional.class);
            toConnect = connect != null ? connect.value() : toConnect;
            withTransaction = transactional != null ? transactional.value() : withTransaction;
            Class<?> implType = service.getClass();
            connect = implType.getAnnotation(Connect.class);
            transactional = implType.getAnnotation(Transactional.class);
            toConnect = connect != null ? connect.value() : toConnect;
            withTransaction = transactional != null ? transactional.value() : withTransaction;
            Method[] methodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                boolean connectingMethod = toConnect;
                boolean transactionalMethod = withTransaction;
                if (method.getDeclaringClass() == ServiceAPI.class) {
                    this.methods.put(method, EnumSet.noneOf(ConnectionFlg.class));
                } else {
                    connect = method.getAnnotation(Connect.class);
                    transactional = method.getAnnotation(Transactional.class);
                    connectingMethod = connect != null ? connect.value() : toConnect;
                    transactionalMethod = transactional != null ? transactional.value() : withTransaction;
                    try {
                        Annotation[] methodAnnotations;
                        Method implMethod = implType.getMethod(method.getName(), method.getParameterTypes());
                        Annotation[] annotationArray = methodAnnotations = implMethod.getDeclaredAnnotations();
                        int n3 = methodAnnotations.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Annotation ann = annotationArray[n4];
                            if (ann instanceof Connect) {
                                connectingMethod = ((Connect)ann).value();
                            } else if (ann instanceof Transactional) {
                                transactionalMethod = ((Transactional)ann).value();
                            }
                            ++n4;
                        }
                    }
                    catch (NoSuchMethodException implMethod) {
                        // empty catch block
                    }
                    EnumSet<ConnectionFlg> flgs = EnumSet.noneOf(ConnectionFlg.class);
                    if (connectingMethod) {
                        flgs.add(ConnectionFlg.USE_CONNECTION);
                    }
                    if (transactionalMethod) {
                        flgs.add(ConnectionFlg.USE_TRANSACTION);
                    }
                    this.methods.put(method, flgs);
                }
                ++n2;
            }
            if (this.log.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append(String.format("method to connection-flg in %s:\n", implType.getName()));
                for (Method method : this.methods.keySet()) {
                    buf.append(method.getName()).append("() : ").append(this.methods.get(method).toString()).append("\n");
                }
                this.log.debug((Object)buf.toString());
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            EnumSet<ConnectionFlg> flgs = this.methods.get(method);
            if (flgs == null) {
                throw new NoSuchMethodException(String.format("%s is not a service method of %s.", method.getName(), this.service.getClass().getName()));
            }
            ServiceSession session = this.service.getSession();
            if (flgs.contains((Object)ConnectionFlg.USE_CONNECTION)) {
                session.connecting = true;
                boolean withTransaction = flgs.contains((Object)ConnectionFlg.USE_TRANSACTION);
                try {
                    if (withTransaction) {
                        session.transactional = true;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)String.format("Method %s() in interface %s is transactional.", method.getName(), this.type.getName()));
                        }
                    }
                    Object result = this.executeMethod(method, args);
                    if (withTransaction) {
                        if (session.status) {
                            session.commit();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)String.format("Method %s() executed and committed.", method.getName()));
                            }
                        } else {
                            session.rollback();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)String.format("Method %s() executed but rollbacked.", method.getName()));
                            }
                        }
                    }
                    Object object = result;
                    return object;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    session.rollback();
                    this.log.fatal((Object)String.format("Method %s() is aborted because of an exception.", method.getName()), (Throwable)e);
                    throw cause;
                }
                finally {
                    this.cleanup(session);
                }
            }
            session.connecting = true;
            Object result = method.invoke((Object)this.service, args);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Method %s() is marked not to use database connection.", method.getName()));
            }
            return result;
        }

        private Object executeMethod(Method method, Object[] args) throws Throwable {
            Validator.Result[] results = Validator.validateArgs(method, args);
            boolean status = true;
            Validator.Result[] resultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Validator.Result result = resultArray[n2];
                status &= result == null;
                ++n2;
            }
            if (status) {
                return method.invoke((Object)this.service, args);
            }
            throw new ServiceValidationException(method, args, results);
        }

        protected void cleanup(ServiceSession session) {
            session.finishup();
        }

        private static enum ConnectionFlg {
            USE_CONNECTION,
            USE_TRANSACTION;

        }
    }
}

