/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.util;

public class PageNavigator {
    public int total = 0;
    public int current = 0;
    public int top = 0;
    public int prev = 0;
    public int begin = 0;
    public int end = -1;
    public int next = 0;
    public int last = 0;
    public int length = 0;
    public int num = 0;

    public PageNavigator() {
    }

    public PageNavigator(int page, int length, int num, int total) {
        this.initialize(page, length, num, total);
    }

    public int head() {
        return (this.current - 1) * this.num + 1;
    }

    public int tail() {
        return Math.min(this.current * this.num, this.total);
    }

    private void initialize(int page, int length, int num, int total) {
        this.total = total;
        this.length = length;
        this.num = num;
        if (page <= 0 || length <= 0 || num <= 0 || total <= 0) {
            return;
        }
        int pageTotal = total / num + (total % num == 0 ? 0 : 1);
        if (page > pageTotal) {
            return;
        }
        this.current = page;
        if (page > 1) {
            this.top = 1;
            this.prev = page - 1;
        }
        if (page < pageTotal) {
            this.last = pageTotal;
            this.next = page + 1;
        }
        int leftPages = length / 2;
        while (leftPages >= page) {
            --leftPages;
        }
        int rightPages = length - 1 - leftPages;
        while (page + rightPages > pageTotal) {
            --rightPages;
            if (page <= leftPages + 1) continue;
            ++leftPages;
        }
        this.begin = page - leftPages;
        this.end = page + rightPages;
    }
}

