/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.validation;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jp.ac.nii.hcp.shared.validation.Size;
import jp.ac.nii.hcp.shared.validation.ValidationAspect;
import jp.ac.nii.hcp.shared.validation.Validator;

class SizeAspect
extends ValidationAspect<Collection<? extends Object>> {
    private int min;
    private int max;

    public SizeAspect(Size size) {
        this.min = size.min();
        this.max = size.max();
    }

    @Override
    protected Class<?> getType() {
        return Size.class;
    }

    @Override
    public Class<?> getTargetType() {
        return Object.class;
    }

    @Override
    protected boolean checkSet() {
        return true;
    }

    @Override
    public Collection<? extends Object> cast(Object arg) {
        Class<?> type = arg.getClass();
        if (type.isArray()) {
            int length = Array.getLength(arg);
            ArrayList<Object> array = new ArrayList<Object>();
            int i = 0;
            while (i < length) {
                array.add(Array.get(arg, i));
                ++i;
            }
            return array;
        }
        if (arg instanceof Collection) {
            return (Collection)arg;
        }
        if (arg instanceof Iterable) {
            final Iterable it = (Iterable)arg;
            return new AbstractCollection<Object>(){
                private int size = -1;

                @Override
                public Iterator<Object> iterator() {
                    return it.iterator();
                }

                @Override
                public int size() {
                    if (this.size < 0) {
                        this.size = 0;
                        Iterator itr = it.iterator();
                        while (itr.hasNext()) {
                            ++this.size;
                            itr.next();
                        }
                    }
                    return this.size;
                }
            };
        }
        return null;
    }

    @Override
    public Validator.Result validate(Collection<? extends Object> arg) {
        if (arg.size() < this.min) {
            return this.ng("min", this.min);
        }
        if (arg.size() > this.max) {
            return this.ng("max", this.max);
        }
        return this.ok();
    }
}

