/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.cli;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.ac.nii.hcp.client.cli.CommandSelector;

class CommandTemplate {
    private static final String EXECUTE_METHOD_NAME = "execute";
    private static final String NULL_STRING = "#null#";
    private String[] commands;
    private Method executor = null;
    private Class<?>[] paramTypes = null;

    public CommandTemplate(String ... commands) {
        Method[] methods;
        this.commands = commands;
        Method[] methodArray = methods = this.getClass().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(EXECUTE_METHOD_NAME)) {
                this.executor = method;
                this.paramTypes = method.getParameterTypes();
                break;
            }
            ++n2;
        }
    }

    protected void setCommands(String ... commands) {
        this.commands = commands;
    }

    protected String[] getCommands() {
        return this.commands;
    }

    protected Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public Object[] accept(String[] args, Object ... extra) {
        if (this.executor == null || this.paramTypes == null) {
            return null;
        }
        Object[] commandArgs = new Object[this.paramTypes.length];
        if (this.commands.length + this.paramTypes.length <= args.length + extra.length) {
            int commandLength = this.commands.length;
            int i = 0;
            while (i < commandLength) {
                if (!args[i].equalsIgnoreCase(this.commands[i])) {
                    return null;
                }
                ++i;
            }
            i = 0;
            while (i < this.paramTypes.length) {
                block30: {
                    Object arg = null;
                    if (args.length > i + commandLength) {
                        arg = args[i + commandLength];
                    } else if (args.length + extra.length > i + commandLength) {
                        arg = extra[i + commandLength - args.length];
                    }
                    if (arg.equals(NULL_STRING)) {
                        commandArgs[i] = null;
                    } else if (this.paramTypes[i].isAssignableFrom(arg.getClass())) {
                        commandArgs[i] = arg;
                    } else if (this.paramTypes[i].isPrimitive()) {
                        String argString;
                        block31: {
                            argString = arg.toString();
                            try {
                                if (this.paramTypes[i] == Boolean.TYPE || this.paramTypes[i] == Boolean.class) {
                                    commandArgs[i] = Boolean.parseBoolean(argString);
                                    break block30;
                                }
                                if (this.paramTypes[i] != Character.TYPE && this.paramTypes[i] != Character.class) break block31;
                                if (argString.length() == 1) {
                                    commandArgs[i] = Character.valueOf(argString.charAt(0));
                                    break block30;
                                }
                                return null;
                            }
                            catch (NumberFormatException e) {
                                return null;
                            }
                        }
                        if (this.paramTypes[i] == Byte.TYPE || this.paramTypes[i] == Byte.class) {
                            commandArgs[i] = Byte.parseByte(argString);
                        } else if (this.paramTypes[i] == Short.TYPE || this.paramTypes[i] == Short.class) {
                            commandArgs[i] = Short.parseShort(argString);
                        } else if (this.paramTypes[i] == Integer.TYPE || this.paramTypes[i] == Integer.class) {
                            commandArgs[i] = Integer.parseInt(argString);
                        } else if (this.paramTypes[i] == Long.TYPE || this.paramTypes[i] == Long.class) {
                            commandArgs[i] = Long.parseLong(argString);
                        } else if (this.paramTypes[i] == Float.TYPE || this.paramTypes[i] == Float.class) {
                            commandArgs[i] = Float.valueOf(Float.parseFloat(argString));
                        } else if (this.paramTypes[i] == Double.TYPE || this.paramTypes[i] == Double.class) {
                            commandArgs[i] = Double.parseDouble(argString);
                        }
                    }
                }
                ++i;
            }
        } else {
            return null;
        }
        return commandArgs;
    }

    public Object invoke(Object[] args) throws Throwable {
        return this.invoke(args, Object.class);
    }

    public <T> T invoke(Object[] args, Class<T> returnType) throws Throwable {
        try {
            return returnType.cast(this.executor.invoke((Object)this, args));
        }
        catch (IllegalAccessException e) {
            throw new InternalError(String.format("Invoking %s failed because of IllegalAccessException.", this.executor.getName()));
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public void inject(CommandSelector.Injector injector) {
    }
}

