/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import jp.ac.nii.hcp.client.cli.CommandSelector;
import jp.ac.nii.hcp.client.cli.CommandTemplate;
import jp.ac.nii.hcp.client.cli.UndefinedCommandException;
import jp.ac.nii.hcp.client.core.FileAttachmentManager;
import jp.ac.nii.hcp.client.core.HCPController;
import jp.ac.nii.hcp.client.core.ImageContentManager;
import jp.ac.nii.hcp.client.core.ProjectEditor;
import jp.ac.nii.hcp.client.net.AuthenticationCache;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.ClientConfiguration;
import jp.ac.nii.hcp.client.shared.CommitConflictException;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.client.workspace.Workspace;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPImage;
import jp.ac.nii.hcp.shared.model.HCPImageList;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.HCPProjectHistory;
import jp.ac.nii.hcp.shared.model.HCPProjectList;
import jp.ac.nii.hcp.shared.model.HCPProjectMember;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.model.ProjectDifference;

public class HCPClient {
    private static BufferedReader reader;
    private static final String WORKSPACE = "../work/workspace";
    private static CommandSelector ProjectCommands;
    private static CommandSelector EditorCommands;
    private static boolean editorMode;
    private static ProjectEditor editor;
    private static boolean quit;
    private static AuthenticationCache auth;

    static {
        editorMode = false;
        editor = null;
        quit = false;
        ProjectCommands = new CommandSelector(new ProjectCommandTemplate(new String[]{"quit"}){

            public void execute() {
                quit = true;
            }
        }, new ProjectCommandTemplate(new String[]{"copy"}){

            public void execute(String copyTo) throws IOException {
                File toDir = new File(copyTo);
                Workspace copied = Workspace.copy(this.hcp.getWorkspace(), toDir);
                if (copied != null) {
                    System.out.println(String.format("Copy OK to %s", toDir.getAbsolutePath()));
                } else {
                    System.out.println(String.format("Copy Failed to %s", toDir.getAbsolutePath()));
                }
            }
        }, new ProjectCommandTemplate(new String[]{"script"}){

            public void execute(String path) throws Throwable {
                File script = new File(path);
                if (script.exists()) {
                    BufferedReader scriptReader = new BufferedReader(new InputStreamReader(new FileInputStream(script)));
                    String line = null;
                    while ((line = scriptReader.readLine()) != null) {
                        HCPClient.execute(line);
                    }
                }
            }
        }, new ProjectCommandTemplate(new String[]{"api", "get"}){

            public void execute(String path) throws IOException, UnauthorizedException {
                InputStream stream = this.hcp.getAPI(path != null ? path : "", InputStream.class);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                System.out.printf("GET to API : %s\n", path);
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"auth"}){

            public void execute() throws IOException {
                auth = this.hcp.login();
                if (auth != null) {
                    HCPClient.outputAuthentication(auth);
                } else {
                    auth = null;
                    System.out.println("No valid authentication token exist.");
                }
            }
        }, new ProjectCommandTemplate(new String[]{"login"}){

            public void execute(String email, String password) throws IOException {
                auth = this.hcp.login(email, password);
                if (auth != null) {
                    HCPClient.outputAuthentication(auth);
                } else {
                    auth = null;
                    System.out.println("Login failed.");
                }
            }
        }, new ProjectCommandTemplate(new String[]{"groups"}){

            public void execute() throws IOException, UnauthorizedException {
                if (auth == null) {
                    System.out.println("Not authorized yet.");
                    return;
                }
                List<HCPUserGroup> groups = this.hcp.getGroups(auth);
                for (HCPUserGroup group : groups) {
                    HCPClient.outputGroup(group);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"users"}){

            public void execute(String groupId) throws IOException, UnauthorizedException {
                if (auth == null) {
                    System.out.println("Not authorized yet.");
                    return;
                }
                List<HCPUser> users = this.hcp.getUsers(groupId);
                for (HCPUser user : users) {
                    HCPClient.outputUser(user);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"status", "project"}){

            public void execute(String name) throws HCPClientException {
                ProjectDifference diff = this.hcp.status(name);
                HCPClient.outputDiff(diff);
            }
        }, new ProjectCommandTemplate(new String[]{"list", "project"}){

            public void execute() {
                List<HCPProject> projects = this.hcp.listProjects();
                System.out.printf("%d projects exists in workspace.\n", projects.size());
                for (HCPProject project : projects) {
                    System.out.printf("Project : %s\n", project.name);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"get", "project"}){

            public void execute(String name) throws HCPClientException {
                HCPProject project = this.hcp.getProject(name);
                if (project != null) {
                    HCPClient.outputProject(project);
                } else {
                    System.out.printf("Project '%s' does not exist.\n", name);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"remove", "project"}){

            public void execute(String name) {
                this.hcp.removeProject(name);
                System.out.printf("Project '%s' is removed from workspace.\n", name);
            }
        }, new ProjectCommandTemplate(new String[]{"create", "project"}){

            public void execute(String name) throws HCPClientException {
                this.hcp.createProject(name);
                System.out.printf("Project '%s' is created in workspace.\n", name);
            }
        }, new ProjectCommandTemplate(new String[]{"fetch", "project"}){

            public void execute(String name) throws IOException, UnauthorizedException, HCPClientException {
                HCPProject project = this.hcp.fetchProject(name);
                if (project != null) {
                    HCPClient.outputProject(project);
                } else {
                    System.out.printf("Project '%s' does not exist in repository.", name);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"search", "project"}){

            public void execute() throws IOException, UnauthorizedException, HCPClientException {
                HCPProjectList projects = this.hcp.searchProjects();
                for (HCPProject project : projects.projects) {
                    System.out.printf("Project : %s\n", project.name);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"checkout", "project"}){

            public void execute(String name) throws IOException, UnauthorizedException, HCPClientException {
                this.hcp.checkoutProject(name, 0);
                System.out.printf("Project '%s' is checkouted in workspace.\n", name);
            }
        }, new ProjectCommandTemplate(new String[]{"import", "project"}){

            public void execute(String name, String groupId) throws IOException, UnauthorizedException, HCPClientException {
                this.hcp.importProject(name, groupId);
                System.out.printf("Project '%s' is imported to repository.\n", name);
            }
        }, new ProjectCommandTemplate(new String[]{"delete", "project"}){

            public void execute(String name) throws IOException, UnauthorizedException, HCPClientException {
                this.hcp.deleteProject(name);
                System.out.printf("Project '%s' is deleted from both repository and workspace.\n", name);
            }
        }, new ProjectCommandTemplate(new String[]{"update", "project"}){

            public void execute(String name, boolean overwrite) throws IOException, UnauthorizedException, HCPClientException {
                ArrayList<HCPProjectContent> ignored = new ArrayList<HCPProjectContent>();
                this.hcp.updateProject(name, null, overwrite, ignored);
                System.out.printf("Project '%s' is updated.\n", name);
                if (ignored.size() > 0) {
                    System.out.printf("Following contents are not updated because they have some editions.", new Object[0]);
                    for (HCPProjectContent content : ignored) {
                        System.out.printf("  id : %s\n", content.id);
                    }
                }
            }
        }, new ProjectCommandTemplate(new String[]{"commit", "project"}){

            /*
             * Unable to fully structure code
             */
            public void execute(String name, String comment, boolean force) throws IOException, UnauthorizedException, HCPClientException {
                block5: {
                    try {
                        this.hcp.commitProject(name, comment, force);
                        System.out.printf("Project '%s' is committed to repository.\n", new Object[]{name});
                        break block5;
                    }
                    catch (CommitConflictException e) {
                        System.out.println("Following contents yielded conflicts.");
                        diff = e.getConflictContents();
                        ** for (content : diff.added)
                    }
lbl-1000:
                    // 1 sources

                    {
                        System.out.printf("  id : %s\n", new Object[]{content.id});
                        continue;
                    }
lbl14:
                    // 2 sources

                    for (HCPProjectContent content : diff.modified) {
                        System.out.printf("  id : %s\n", new Object[]{content.id});
                    }
                    for (HCPProjectContent content : diff.deleted) {
                        System.out.printf("  id : %s\n", new Object[]{content.id});
                    }
                }
            }
        }, new ProjectCommandTemplate(new String[]{"fetch", "material"}){

            public void execute(String name, String id) throws IOException, UnauthorizedException, HCPClientException {
                HCPMaterial material = this.hcp.fetchMaterial(name, id);
                if (material != null) {
                    HCPClient.outputMaterial(material);
                } else {
                    System.out.printf("Material '%s' does not exist in project '%s'.\n", id, name);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"fetch", "document"}){

            public void execute(String name, String id, int revision) throws IOException, UnauthorizedException, HCPClientException {
                HCPDocument document = this.hcp.fetchDocument(name, id, revision);
                if (document != null) {
                    HCPClient.outputDocument(document);
                } else {
                    System.out.printf("Document '%s' does not exist in project '%s'.\n", id, name);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"fetch", "attachment"}){

            public void execute(String name, String id) throws IOException, UnauthorizedException, HCPClientException {
                HCPAttachment attachment = this.hcp.fetchAttachment(name, id);
                if (attachment != null) {
                    HCPClient.outputAttachment(attachment);
                } else {
                    System.out.printf("Attachment '%s' does not exist in project '%s'.\n", id, name);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"fetch", "history"}){

            public void execute(String name, int from, int to) throws IOException, UnauthorizedException {
                List<HCPProjectHistory> histories = this.hcp.fetchHistories(name, from, to);
                System.out.printf("History of project '%s' from %d to %d.\n", name, from, to);
                for (HCPProjectHistory history : histories) {
                    HCPClient.outputHistory(history);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"set", "access"}){

            public void execute(String name, String accString) throws IOException, UnauthorizedException {
                HCPProject.Accessibility accessibility = HCPProject.Accessibility.PRIVATE;
                if (accString.equalsIgnoreCase("public")) {
                    accessibility = HCPProject.Accessibility.PUBLIC;
                }
                this.hcp.setAccessibility(name, accessibility);
                System.out.printf("Accessibility of project '%s' is set to %s.\n", name, accessibility);
            }
        }, new ProjectCommandTemplate(new String[]{"get", "members"}){

            public void execute(String name) throws IOException, UnauthorizedException {
                List<HCPProjectMember> members = this.hcp.getMembers(name);
                for (HCPProjectMember member : members) {
                    System.out.printf("Member :\n  Group ID    : %s\n  Group name  : %s\n  Relation    : %s\n  Permission  : %s\n", member.group.id, member.group.name, member.relation, member.permission);
                }
            }
        }, new ProjectCommandTemplate(new String[]{"set", "member"}){

            public void execute(String name, String groupId, String permString) throws IOException, UnauthorizedException {
                HCPProject.GroupPermission permission = HCPProject.GroupPermission.READ_ONLY;
                if (permString.equalsIgnoreCase("rw")) {
                    permission = HCPProject.GroupPermission.WRITEABLE;
                }
                this.hcp.setMember(name, groupId, permission);
                System.out.printf("Permission of group '%s' in project '%s' is set to %s\n", groupId, name, permission);
            }
        }, new ProjectCommandTemplate(new String[]{"delete", "member"}){

            public void execute(String name, String groupId) throws IOException, UnauthorizedException {
                this.hcp.deleteMember(name, groupId);
                System.out.printf("Group '%s' is deleted from members of project '%s'\n", groupId, name);
            }
        }, new ProjectCommandTemplate(new String[]{"upload", "attachment"}){

            public void execute(String name, String id, String path, String contentType, String description, String entity) throws IOException, UnauthorizedException, HCPClientException {
                FileAttachmentManager manager = this.hcp.getAttachmentManager(name);
                File entityFile = new File(entity);
                manager.addFileAttachment(id, path, contentType, description, entityFile);
                System.out.printf("Attachment file '%s' is registered in repository as '%s' and copied into workspace as '%s'\n", entity, id, path);
            }
        }, new ProjectCommandTemplate(new String[]{"open", "project"}){

            public void execute(String name) throws HCPClientException {
                editor = this.hcp.openProject(name);
                EditorCommands.inject(new EditorCommandTemplate.Injector(editor));
                if (editor != null) {
                    System.out.printf("Start editing project '%s'.\n", name);
                    editorMode = true;
                }
            }
        }, new ProjectCommandTemplate(new String[]{"image", "g-add"}){

            public void execute(String id, String code, String url) throws Exception {
                ImageContentManager manager = this.hcp.getImageManager();
                HCPUserGroup group = new HCPUserGroup(0, id, null, null);
                manager.add(group, code, url);
            }
        }, new ProjectCommandTemplate(new String[]{"image", "get"}){

            public void execute(String ownerCode, String imageCode) throws Exception {
                ImageContentManager manager = this.hcp.getImageManager();
                HCPImage image = manager.fetch(ownerCode, imageCode);
                HCPClient.outputImage(image);
            }
        }, new ProjectCommandTemplate(new String[]{"image", "list"}){

            public void execute(String id, int page, int limit) throws Exception {
                ImageContentManager manager = this.hcp.getImageManager();
                HCPImageList images = manager.search(id, page, limit);
                for (HCPImage image : images.images) {
                    System.out.printf("Image : image code = %s\n", image.image_code);
                }
            }
        });
        ProjectCommands.enableHelp();
        EditorCommands = new CommandSelector(new EditorCommandTemplate(new String[]{"close"}){

            public void execute() {
                System.out.printf("Finish editing mode.\n", new Object[0]);
                editorMode = false;
                this.editor = null;
            }
        }, new EditorCommandTemplate(new String[]{"get", "material"}){

            public void execute(String id) throws HCPClientException {
                HCPMaterial model = this.editor.getMaterial(id);
                if (model != null) {
                    HCPClient.outputMaterial(model);
                } else {
                    System.out.printf("Material '%s' does not exist.\n", id);
                }
            }
        }, new EditorCommandTemplate(new String[]{"get", "document"}){

            public void execute(String id) throws HCPClientException {
                HCPDocument model = this.editor.getDocument(id);
                if (model != null) {
                    HCPClient.outputDocument(model);
                } else {
                    System.out.printf("Document '%s' does not exist.\n", id);
                }
            }
        }, new EditorCommandTemplate(new String[]{"get", "attachment"}){

            public void execute(String id) throws HCPClientException {
                HCPAttachment model = this.editor.getAttachment(id);
                if (model != null) {
                    HCPClient.outputAttachment(model);
                } else {
                    System.out.printf("Attachment '%s' does not exist.\n", id);
                }
            }
        }, new EditorCommandTemplate(new String[]{"get", "materials"}){

            public void execute() throws HCPClientException {
                List<HCPMaterial> models = this.editor.getMaterials();
                System.out.printf("%d materials exist in this project.\n", models.size());
                for (HCPMaterial model : models) {
                    System.out.printf("Material : %s\n", model.id);
                }
            }
        }, new EditorCommandTemplate(new String[]{"get", "documents"}){

            public void execute() throws HCPClientException {
                List<HCPDocument> models = this.editor.getDocuments();
                System.out.printf("%d documents exist in this project.\n", models.size());
                for (HCPDocument model : models) {
                    System.out.printf("Document : %s\n", model.id);
                }
            }
        }, new EditorCommandTemplate(new String[]{"get", "attachments"}){

            public void execute() throws HCPClientException {
                List<HCPAttachment> models = this.editor.getAttachments();
                System.out.printf("%d attachments exist in this project.\n", models.size());
                for (HCPAttachment model : models) {
                    System.out.printf("Attachment : %s\n", model.id);
                }
            }
        }, new EditorCommandTemplate(new String[]{"add", "material"}){

            public void execute(String id, String imagePath, String description) throws HCPClientException {
                this.editor.addMaterial(id, imagePath, description);
            }
        }, new EditorCommandTemplate(new String[]{"add", "document"}){

            public void execute(String id, String source, String description) throws HCPClientException {
                this.editor.addDocument(id, source, description);
            }
        }, new EditorCommandTemplate(new String[]{"add", "attachment"}){

            public void execute(String id, String source, String description) throws HCPClientException {
                this.editor.addTextAttachment(id, source, description);
            }
        }, new EditorCommandTemplate(new String[]{"set", "document"}){

            public void execute(String id, String source) throws HCPClientException {
                this.editor.setDocument(id, source);
            }
        }, new EditorCommandTemplate(new String[]{"set", "attachment"}){

            public void execute(String id, String source) throws HCPClientException {
                this.editor.setTextAttachment(id, source);
            }
        }, new EditorCommandTemplate(new String[]{"remove", "material"}){

            public void execute(String id) throws HCPClientException {
                this.editor.removeMaterial(id);
            }
        }, new EditorCommandTemplate(new String[]{"remove", "document"}){

            public void execute(String id) throws HCPClientException {
                this.editor.removeDocument(id);
            }
        }, new EditorCommandTemplate(new String[]{"remove", "attachment"}){

            public void execute(String id) throws HCPClientException {
                this.editor.removeAttachment(id);
            }
        }, new EditorCommandTemplate(new String[]{"set", "description"}){

            public void execute(String id, String description) throws HCPClientException {
                this.editor.setDescription(id, description);
            }
        });
        EditorCommands.enableHelp();
    }

    public static void main(String[] args) throws Throwable {
        HCPController hcp;
        Class.forName("org.sqlite.JDBC");
        String wsDir = WORKSPACE;
        if (args.length > 0) {
            wsDir = args[0];
        }
        if ((hcp = HCPController.get(wsDir, new ClientConfiguration())) == null) {
            System.err.printf("%s is unavailable as workspace directory.", wsDir);
        }
        ProjectCommandTemplate.Injector projectInjector = new ProjectCommandTemplate.Injector(hcp);
        ProjectCommands.inject(projectInjector);
        reader = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        while (!quit && (line = reader.readLine()) != null) {
            HCPClient.execute(line);
        }
    }

    private static void outputAuthentication(AuthenticationCache auth) {
        System.out.println(String.format("Authenticated :\n  user  : %s\n  group : %s", auth.user.id, auth.group != null ? auth.group.id : null));
    }

    private static void outputProject(HCPProject project) {
        System.out.println(String.format("Project :\n  name          : %s\n  revision      : %d\n  accessibility : %s\n  owner group   : %s\n  created       : %s\n  modified      : %s\n", project.name, project.revision, project.accessibility, project.group, project.created, project.modified));
    }

    private static void outputMaterial(HCPMaterial material) {
        HCPProjectContent.Record record = material.record;
        System.out.printf("Material :\n  sequence      : %d\n  id            : %s\n  image path    : %s\n  description   : %s\n  added         : %d\n  revision      : %d\n  created       : %s\n  created by    : %s\n  creator ln    : %s\n  creator fn    : %s\n  modified      : %s\n  modified by   : %s\n  modifier ln   : %s\n  modifier fn   : %s\n", material.sequence, material.id, material.imagePath, material.description, record.added, record.revision, record.created, record.createdBy.id, record.createdBy.lastName, record.createdBy.firstName, record.modified, record.modifiedBy.id, record.modifiedBy.lastName, record.modifiedBy.firstName);
    }

    private static void outputDocument(HCPDocument document) {
        HCPProjectContent.Record record = document.record;
        System.out.printf("Document :\n  sequence      : %d\n  id            : %s\n  source        : %s\n  description   : %s\n  added         : %d\n  revision      : %d\n  created       : %s\n  created by    : %s\n  creator ln    : %s\n  creator fn    : %s\n  modified      : %s\n  modified by   : %s\n  modifier ln   : %s\n  modifier fn   : %s\n", document.sequence, document.id, document.source, document.description, record.added, record.revision, record.created, record.createdBy.id, record.createdBy.lastName, record.createdBy.firstName, record.modified, record.modifiedBy.id, record.modifiedBy.lastName, record.modifiedBy.firstName);
    }

    private static void outputAttachment(HCPAttachment attachment) {
        HCPProjectContent.Record record = attachment.record;
        System.out.printf("Attachment :\n  sequence      : %d\n  id            : %s\n  content type  : %s\n  source        : %s\n  file path     : %s\n  description   : %s\n  added         : %d\n  revision      : %d\n  created       : %s\n  created by    : %s\n  creator ln    : %s\n  creator fn    : %s\n  modified      : %s\n  modified by   : %s\n  modifier ln   : %s\n  modifier fn   : %s\n", attachment.sequence, attachment.id, attachment.contentType, attachment.source, attachment.filePath, attachment.description, record.added, record.revision, record.created, record.createdBy.id, record.createdBy.lastName, record.createdBy.firstName, record.modified, record.modifiedBy.id, record.modifiedBy.lastName, record.modifiedBy.firstName);
    }

    private static void outputUser(HCPUser user) {
        System.out.printf("User :\n  id            : %s\n  email         : %s\n  last name     : %s\n  first name    : %s\n  organization  : %s\n  post          : %s\n", user.id, user.email, user.lastName, user.firstName, user.organization, user.post);
    }

    private static void outputGroup(HCPUserGroup group) {
        System.out.printf("Group :\n  id            : %s\n  name          : %s\n  description   : %s\n", group.id, group.name, group.description);
    }

    private static void outputDiff(ProjectDifference diff) {
        System.out.printf("Difference :\n  revision      : %d\n  added         :\n", diff.revision);
        for (HCPProjectContent content : diff.added) {
            System.out.printf("    - %s\n", content.id);
        }
        System.out.printf("  modified      :\n", new Object[0]);
        for (HCPProjectContent content : diff.modified) {
            System.out.printf("    - %s\n", content.id);
        }
        System.out.printf("  deleted       :\n", new Object[0]);
        for (HCPProjectContent content : diff.deleted) {
            System.out.printf("    - %s\n", content.id);
        }
    }

    private static void outputImage(HCPImage image) {
        System.out.printf("Image :\n  owner code     : %s\n  owner type     : %s\n  image code     : %s\n  url            : %s\n  created        : %s\n", image.owner_code, image.owner_type, image.image_code, image.url, image.created);
    }

    private static void outputHistory(HCPProjectHistory history) {
        System.out.printf("History :\n  revision       : %d\n  remarks        : %s\n  created        : %s\n  created_by     : %s\n", history.revision, history.remarks, history.created, history.createdBy.id);
    }

    private static Object execute(String line) throws Throwable {
        try {
            if (editorMode) {
                return HCPClient.executeEditorCommand(line);
            }
            return HCPClient.executeCommand(line);
        }
        catch (UndefinedCommandException e) {
            e.printStackTrace();
        }
        catch (UnauthorizedException e) {
            System.out.println("Not authorized yet.");
        }
        catch (HCPClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Object executeCommand(String line) throws Throwable {
        return ProjectCommands.invoke(line);
    }

    private static Object executeEditorCommand(String line) throws Throwable {
        return EditorCommands.invoke(line);
    }

    private static class EditorCommandTemplate
    extends CommandTemplate {
        protected ProjectEditor editor;

        public EditorCommandTemplate(String ... commands) {
            super(commands);
        }

        @Override
        public void inject(CommandSelector.Injector injector) {
            if (injector instanceof Injector) {
                this.editor = ((Injector)injector).editor;
            }
        }

        public static class Injector
        implements CommandSelector.Injector {
            private ProjectEditor editor;

            public Injector(ProjectEditor editor) {
                this.editor = editor;
            }
        }
    }

    private static class ProjectCommandTemplate
    extends CommandTemplate {
        protected HCPController hcp;

        public ProjectCommandTemplate(String ... commands) {
            super(commands);
        }

        @Override
        public void inject(CommandSelector.Injector injector) {
            if (injector instanceof Injector) {
                this.hcp = ((Injector)injector).hcp;
            }
        }

        public static class Injector
        implements CommandSelector.Injector {
            private HCPController hcp;

            public Injector(HCPController hcp) {
                this.hcp = hcp;
            }
        }
    }
}

