/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.core;

import java.io.File;
import java.io.IOException;
import jp.ac.nii.hcp.client.core.SynchronizedWorkspaceController;
import jp.ac.nii.hcp.client.net.RepositoryConnection;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.ClientConfiguration;
import jp.ac.nii.hcp.client.workspace.Workspace;

public class HCPController
extends SynchronizedWorkspaceController {
    static {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("SQLite library is not found in classpath");
        }
    }

    public static HCPController get(File wsDir, ClientConfiguration config) {
        Workspace ws = null;
        if (!wsDir.exists()) {
            ws = Workspace.create(wsDir);
        } else if (wsDir.isDirectory()) {
            File[] files = wsDir.listFiles();
            ws = files.length == 0 ? Workspace.create(wsDir) : Workspace.get(wsDir);
        }
        if (ws != null) {
            return new HCPController(ws, config);
        }
        return null;
    }

    public static HCPController get(String wsDir, ClientConfiguration config) {
        return HCPController.get(new File(wsDir), config);
    }

    public static HCPController create(File wsDir, ClientConfiguration config) {
        Workspace ws = Workspace.create(wsDir);
        if (ws != null) {
            return new HCPController(ws, config);
        }
        return null;
    }

    public static HCPController create(String wsDir, ClientConfiguration config) {
        return HCPController.create(new File(wsDir), config);
    }

    protected HCPController(Workspace ws, ClientConfiguration config) {
        super(ws, config);
    }

    public <T> T getAPI(String path, Class<T> responseType) throws IOException, UnauthorizedException {
        RepositoryConnection connection = this.getConnection();
        ClientConfiguration config = this.getConfiguration();
        return connection.request(config.repositoryAPIURL().append(path).toUrl(), "GET", null, null, responseType);
    }
}

