/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jp.ac.nii.hcp.client.workspace.AbstractWorkspace;
import jp.ac.nii.hcp.client.workspace.AuthSpace;
import jp.ac.nii.hcp.client.workspace.ImageSpace;
import jp.ac.nii.hcp.client.workspace.RepositorySpace;

public class Workspace
extends AbstractWorkspace {
    private static final String AUTH_DIR = "auth";
    private static final String IMAGE_DIR = "image";
    private static final String REPOSITORY_DIR = "repository";
    private static Map<File, Workspace> spaces = new HashMap<File, Workspace>();
    private AuthSpace authSpace;
    private ImageSpace imageSpace;
    private RepositorySpace repositorySpace;

    protected Workspace() {
        super(null);
    }

    private Workspace(File root) {
        super(root);
        File authDir = new File(this.root, AUTH_DIR);
        File imageDir = new File(this.root, IMAGE_DIR);
        File repositoryDir = new File(this.root, REPOSITORY_DIR);
        this.authSpace = new AuthSpace(authDir);
        this.imageSpace = new ImageSpace(imageDir);
        this.repositorySpace = RepositorySpace.get(repositoryDir);
    }

    private static boolean initialize(File root) {
        File authDir = new File(root, AUTH_DIR);
        File imageDir = new File(root, IMAGE_DIR);
        File repositoryDir = new File(root, REPOSITORY_DIR);
        return authDir.mkdir() && imageDir.mkdir() && repositoryDir.mkdir();
    }

    public static Workspace create(File root) {
        Workspace workspace = null;
        if (!root.exists()) {
            if (root.mkdirs() && Workspace.initialize(root)) {
                workspace = new Workspace(root);
            }
        } else {
            File[] files = root.listFiles();
            if (files != null && files.length == 0 && Workspace.initialize(root)) {
                workspace = new Workspace(root);
            }
        }
        if (workspace != null && workspace.validate()) {
            spaces.put(root, workspace);
            return workspace;
        }
        return null;
    }

    public static Workspace get(File root) {
        if (spaces.containsKey(root)) {
            return spaces.get(root);
        }
        Workspace workspace = new Workspace(root);
        if (workspace.validate()) {
            spaces.put(root, workspace);
            return workspace;
        }
        return null;
    }

    public static Workspace copy(Workspace ws, File copyTo) throws IOException {
        Workspace copied = Workspace.create(copyTo);
        if (copied == null) {
            return null;
        }
        Workspace.copyDirectory(ws.getImageSpace().root, copied.getImageSpace().root);
        Workspace.copyDirectory(ws.getRepositorySpace().root, copied.getRepositorySpace().root);
        return copied;
    }

    private static void copyDirectory(File from, File to) throws IOException {
        File[] fromFiles = from.listFiles();
        byte[] buf = new byte[4096];
        File[] fileArray = fromFiles;
        int n = fromFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File ff = fileArray[n2];
            if (ff.isDirectory()) {
                File toDir = new File(to, ff.getName());
                toDir.mkdir();
                Workspace.copyDirectory(ff, toDir);
            } else {
                File toFile = new File(to, ff.getName());
                FileInputStream in = new FileInputStream(ff);
                FileOutputStream out = new FileOutputStream(toFile);
                int bytes = 0;
                while ((bytes = in.read(buf)) >= 0) {
                    out.write(buf, 0, bytes);
                }
                in.close();
                out.close();
            }
            ++n2;
        }
    }

    @Override
    public boolean validate() {
        return super.validate() && this.authSpace != null && this.authSpace.validate() && this.imageSpace != null && this.imageSpace.validate() && this.repositorySpace != null && this.repositorySpace.validate();
    }

    public AuthSpace getAuthSpace() {
        return this.authSpace;
    }

    public ImageSpace getImageSpace() {
        return this.imageSpace;
    }

    public RepositorySpace getRepositorySpace() {
        return this.repositorySpace;
    }
}

