/* $Id: FormatActionTest.java 125 2011-03-09 09:49:51Z ohura $ */
/*
GNU Lesser General Public License

FormatAction
Copyright (C) 2000 Howard Kistler

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

package com.hexidec.ekit.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;

import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.SimpleInfoDialog;


/** Class for implementing HTML format actions
 * (NOTE : Does not toggle. User must use the "Clear Format" option to remove formatting correctly.)
 */
public class FormatActionTest 
{
	protected GSHTMLEditor parentEkit;
	HTML.Tag htmlTag;
	protected int maxlength;

	public FormatActionTest(GSHTMLEditor ekit, HTML.Tag inTag,int maxlength)
	{
		parentEkit = ekit;
		htmlTag    = inTag;
		this.maxlength = maxlength;
	}

	public void actionPerformed()
	{
		aSelect();
		if(1 == 1){
			return;
		}
		JTextPane parentTextPane = parentEkit.getTextPane();
		String selText = parentTextPane.getSelectedText();
		int textLength = -1;
		if(selText != null)
		{
			textLength = selText.length();
		}
		if(selText == null || textLength < 1)
		{
			SimpleInfoDialog sidWarn = new SimpleInfoDialog(parentEkit.getFrame(), "", true, "No text was selected.*", SimpleInfoDialog.ERROR);
		}
		else
		{
			SimpleAttributeSet sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			sasText.addAttribute(SimpleAttributeSet.EMPTY, new SimpleAttributeSet());
			int caretOffset = parentTextPane.getSelectionStart();
			parentTextPane.select(caretOffset, caretOffset + textLength);
			parentTextPane.setCharacterAttributes(sasText, true);
			parentEkit.refreshOnUpdate();
			parentTextPane.select(caretOffset, caretOffset + textLength);

			
/*			SimpleAttributeSet sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());

			Enumeration e = sasText.getAttributeNames();
			int anIndex = 0;
			while (e.hasMoreElements()) {
				Object nexte = e.nextElement();
				if (nexte.toString().toLowerCase().equals("color")) {
					sasText.removeAttribute(nexte);
					break;
				}
			}
			sasText.addAttribute(SimpleAttributeSet.EMPTY, new SimpleAttributeSet());
			int caretOffset = parentTextPane.getSelectionStart();
			parentTextPane.select(caretOffset, caretOffset + textLength);
			parentTextPane.setCharacterAttributes(sasText, true);
			parentEkit.refreshOnUpdate();
			parentTextPane.select(caretOffset, caretOffset + textLength); */
		}
	}
	public void aSelect(){
		JTextPane parentTextPane = parentEkit.getTextPane();
		int textStart =  parentTextPane.getCaretPosition();
		int start = textStart;
		start++;
		int end   = textStart;
		SimpleAttributeSet sasText = null;
		// 前方方法をチェック
		boolean isA = false;
		for(int i=textStart;i<maxlength;i++){
			parentTextPane.setSelectionStart(i);
			sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(HTML.Tag.A.toString())){
					System.out.println("-");
					end++;
					check = true;
					isA = true;
				}
			}
			if(!check){
				break;
			}
		}
		// 後方をチェック
		for(int i=textStart;i>0;i--){
			parentTextPane.setSelectionStart(i);
			parentTextPane.setSelectionEnd(i);
			sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(HTML.Tag.A.toString())){
					System.out.println(start);
					start--;
					check = true;
					isA = true;
				}
			}
			if(!check){
				break;
			}
		}
/*		for(int i=0;i<maxlength;i++){
			parentTextPane.setSelectionStart(i);
			parentTextPane.setSelectionEnd(i);
			sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			System.out.print(i + ":");
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(HTML.Tag.A.toString())){
					System.out.println("-");
					end++;
					check = true;
				}
			}
			if(!check){
				System.out.println("");
			}
		}

		for(int i=maxlength;i>=1;i--){
			parentTextPane.setSelectionStart(i);
			parentTextPane.setSelectionEnd(i);
			sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			System.out.print(i + ":");
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(HTML.Tag.A.toString())){
					System.out.println("-");
					end++;
					check = true;
				}
			}
			if(!check){
				System.out.println("");
			}
		} */

		
		parentTextPane.setSelectionStart(start);
		parentTextPane.setSelectionEnd(end);
/*		int caretOffset = parentTextPane.getSelectionStart();
		int internalTextLength = selText.length();
		String currentAnchor = "";
		// Somewhat ham-fisted code to obtain the first HREF in the selected text,
		// which (if found) is passed to the URL HREF request dialog.
			SimpleAttributeSet sasText = null;
			for(int i = caretOffset; i < caretOffset + internalTextLength; i++){
				parentTextPane.select(i, i + 1);
				sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
				Enumeration attribEntries1 = sasText.getAttributeNames();
				while(attribEntries1.hasMoreElements() && currentAnchor.equals("")){
					Object entryKey   = attribEntries1.nextElement();
					Object entryValue = sasText.getAttribute(entryKey);
					if(entryKey.toString().equals(HTML.Tag.A.toString())){
						if(entryValue instanceof SimpleAttributeSet){
							Enumeration subAttributes = ((SimpleAttributeSet)entryValue).getAttributeNames();
							while(subAttributes.hasMoreElements() && currentAnchor.equals("")){
								Object subKey = subAttributes.nextElement();
								if(subKey.toString().toLowerCase().equals("href")){
									currentAnchor = ((SimpleAttributeSet)entryValue).getAttribute(subKey).toString();
									break;
								}
							}
						}
					}
				}
				if(!currentAnchor.equals("")) { break; }
			} */
		
	}

}

