/* $Id: PagedRect.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 作成日： 2006/08/28
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.awt.Rectangle;

/**
 * @author hajime
 * <p>
 * PagedRect は ページ情報付きRectangle型です。
 * DocumentSearcher クラスの search メソッドに対する戻り値や、confirmメソッドに対する戻り値で利用されます。
 * ほとんどの場合、PagedRect[]のように配列形式で利用されます。
 * PagedRect は、本システムが領域を表す際の基本単位になります。
 * </p>
 */
public class PagedRect implements QueryPiece {
    
    protected final int pageIndex_ ;
    protected final Rectangle area_;
    protected final int lineIndex_;
    protected final int slitIndex_;
    
    
    /**
     * @param pageIndex
     * @param area
     * @deprecated
     */
    public PagedRect(int pageIndex, Rectangle area){
        pageIndex_ = pageIndex;
        area_ = new Rectangle(area);
        lineIndex_ = -1;
        slitIndex_ = -1;
    }
    
    public PagedRect(int pageIndex, Rectangle area, int lineNo, int slitNo){
    	pageIndex_ = pageIndex;
        area_ = new Rectangle(area);
        lineIndex_ = lineNo;
        slitIndex_ = slitNo;
    }
    
    /**
     * <p></p>
     * @return ページ番号を返します。
     */
    public int getPageIndex(){
    	return pageIndex_;
    }
    
    /**
     * <p></p>
     * @return 領域を表すjava.awt.Rectangleオブジェクトを返します。
     */
    public Rectangle getRect(){
    	return area_;
    }

	public int getLineIndex() {
		return lineIndex_;
	}

	public int getSlitIndex() {
		return slitIndex_;
	}

    
}
