/* $Id: ResultRects.java 503 2012-05-23 18:14:19Z shayashi $ */
/*
 * 作成日： 2006/08/25
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.util.*;

/**
 * @author hajime
 * <p>ResultRects はスコアとPagedRect[]がセットになったFoundRectのリストを保持するオブジェクトです。
 * IDocumentSearcherの search メソッドに対する戻り値として利用されます。</p>
 */
public class ResultRects {
    
    /**
     * 
     */
    protected ArrayList resultList_;
    
    /**
     * 
     */
    public ResultRects(){
        resultList_ = new ArrayList();
    }
    
    /**
     * <p></p>
     * @param frect
     */
    public void addResult(FoundRect frect){
        resultList_.add(frect);
    }
    
    /**
     * <p>検索の結果、第rank位に検出された領域をPagedRect[]形式で返します。
     * 順位は、rank=1 が最上位である。配列の添字が0から始まるのとの違いに注意。</p>
     * @param rank
     * @return 第rank位に検出された領域を表すPagedRect[]形式
     */
    public PagedRect[] getPRects(int rank){
    	if(rank==0){
    		//PRINT("rankは1以上で指定してね。");
    		return null;
    	}
    	FoundRect frect=(FoundRect)resultList_.get(rank - 1);
    	return frect.getPRects();
    }
    
    /**
     * <p></p>
     * @param rank
     * @return rank位のFoundRect
     */
    public FoundRect getFoundRect(int rank) {
        return (FoundRect) resultList_.get(rank - 1);
    }
    
    /**
     * <p>検索の結果、第rank位に検出された領域のマッチングスコアを返します。
     * マッチングスコアは類似度（大きいほど似ている）だったり
     * 非類似度（小さいほど似ている）だったりするので、
     * その意味については別途実装者に確認が必要です。
     * </p>
     * @param rank
     * @return 第rank位に検出された領域のマッチングスコア。
     */
    public double getScore(int rank){
    	if(rank==0){
    		//PRINT("rankは1以上で指定してね。");
    		return -1;
    	}
    	FoundRect frect=(FoundRect)resultList_.get(rank-1);
    	return frect.getscore();
    }
    
    /**
     * <p>検索結果として出力された領域の数を返します。
     * 検索の結果、いくつの領域が検出されたのかを返します。
     * getsize()の戻り値がnであれば、getscoreおよびgetPRectsの引数として1〜nが有効であるということを意味します。
     * </p>
     * @return 検索結果として出力された領域の数。
     */
    public int getSize(){
    	return resultList_.size();
    }
    
    /**
     * <p></p>
     * @param pageNum
     * @return
     */
    public FoundRect[] getPRectsInPage(int pageNum) {
        ArrayList retList = new ArrayList();
        for (Iterator iter = resultList_.iterator(); iter.hasNext();) {
            FoundRect found = (FoundRect) iter.next();
            if (chkInPage(found.getPRects(), pageNum)) {
                retList.add(found);
            }
        }
        return (FoundRect[]) retList.toArray(new FoundRect[0]);
    }
    
    /**
     * <p></p>
     * @param rects
     * @param pageIndex
     * @return
     */
    protected boolean chkInPage(PagedRect[] rects, int pageIndex){
        boolean flag = false;
        for (int i = 0; i < rects.length; i++) {
            if(rects[i].getPageIndex() == pageIndex) flag = true;
        }
        return flag;
    }
}
