/* $Id: ResourcePointer.java 1083 2016-04-01 15:19:16Z shayashi $ */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.GSResource;
import smart_gs.util.GSLog;

/**
 * 
 * @author kazuaki kobayashi
 * 
 *
 */
public class ResourcePointer {
	public static final int OUT = 0;
	public static final int IN = 1;
	public static final int BOTH = 2;


	protected GSResource resource;

	protected String name = new String();
	
	protected List<ResourcePointer> targets = null;
	protected List<ResourcePointer> sources = null;
	protected List<Connection> connections = null;
	protected boolean is_zombie_pointer = false;
	protected String zombie_uri = null;
	protected String zombie_original_uri = null;


	private boolean isSource = true;
		
	/**
	 * @return the isSource
	 */
	public boolean isSource() {
		return isSource;
	}
	/**
	 * @param isSource the isSource to set
	 */
	public void setSource(boolean isSource) {
		this.isSource = isSource;
	}
	public ResourcePointer(GSResource element){
		this.resource = element;
		this.connections = new ArrayList<Connection>();
		this.targets = new ArrayList<ResourcePointer>();
		this.sources = new ArrayList<ResourcePointer>();
	}
	
	public ResourcePointer(String zombie_uri, String zombie_original_uri){
		this.is_zombie_pointer = true;
		this.zombie_uri = zombie_uri;
		this.zombie_original_uri = zombie_original_uri;
		this.resource = null;
		this.connections = new ArrayList<Connection>();
		this.targets = new ArrayList<ResourcePointer>();
		this.sources = new ArrayList<ResourcePointer>();
	}
	
	public List<ResourcePointer> getForwardLinkElements(){
		return this.targets;
	}
	public List<ResourcePointer> getBackLinkElements(){
		return this.sources;
	}
	public List<Connection> getConnections(){
		return this.connections;
	}
	
	public List<RWElement> getDirectLinkElements(){
		List<RWElement> elements = new ArrayList<RWElement>();
		for(int i=0;i<this.targets.size();i++){
			elements.add(this.targets.get(i).getGSResource());
		}
		for(int i=0;i<this.sources.size();i++){
			elements.add(this.sources.get(i).getGSResource());
		}
		return elements;
	}

	public void addConnection(Connection connection){
		this.connections.add(connection);
	}

	public void addTarget(ResourcePointer target){
		this.targets.add(target);
	}
	
	public void addSource(ResourcePointer source){
		this.sources.add(source);
	}
	
	public GSResource getGSResource(){
		return this.resource;
	}
	
	public void setRwElement(GSResource resource) {
		this.resource = resource;
	}
	public boolean hasLink() {
		if(this.connections.size() <= 0){
			return false;
		}
		return true;
	}
	public boolean hasTarget() {
		if (this.targets.size() <= 0) {
			return false;
		}
		return true;
	}
	public boolean hasSource() {
		if (this.sources.size() <= 0) {
			return false;
		}
		return true;
	}
	
	public String getSource() throws NotMarkupException {
		throw new NotMarkupException();
	}
	
	//2007/10/23 kazuhiro kobayashi
	public void setName(String name){
		this.name = name;
		
	}
	public String getName(){
		return this.name;
	}
	//2007/11/1 kazuhiro kobayashi
	public boolean hasConnection(){
		//2007/11/19 kazuhiro kobayashi
		return this.connections.size() > 0;
	}
	public void removeConnection(Connection connection){
		this.connections.remove(connection);
	}
	
	public String getZombieURI() {
		if (is_zombie_pointer) {
			return this.zombie_uri;
		} else {
			if (this.resource != null) {
				return this.resource.getURI();
			} else {
				GSLog.getInstance().debug("Unknown Zombie found!");
				return new String("unknown zombie!");
			}
		}
	}
	
	public String getZombieOriginalURI() {
		if (is_zombie_pointer) {
			return this.zombie_original_uri;
		} else {
			if (this.resource != null) {
				return this.resource.getOriginalURI();
			} else {
				GSLog.getInstance().debug("Unknown Zombie found!");
				return new String("unknown zombie!");
			}
		}
	}
	
	public boolean isZombieByRestore () {
		return this.is_zombie_pointer;
	}
	
	public boolean isZombified () {
		if (isZombieByRestore()) {
			return true;
		} 
		if (this.resource != null) {
			return resource.isZombie();
		} 
		return false;
	}
}
